<?php
if ( ! defined('ABSPATH') ) exit;

/**
 * Frontend Support View
 * Used ONLY via shortcode [ipm_support_tabs]
 * Data source: Options (array storage)
 */

$support_types  = get_option('ipm_support_types', []);
$support_items  = get_option('ipm_support_type_details', []);

/* Active tab */
$active_type = isset($_GET['type']) ? sanitize_text_field($_GET['type']) : '';

/* Pick first active type if none selected */
if ( empty($active_type) && ! empty($support_types) ) {
    foreach ($support_types as $t) {
        if ( ($t['status'] ?? '') === 'active' ) {
            $active_type = $t['name'];
            break;
        }
    }
}
?>

<div class="ipm-support-wrapper">

    <!-- =====================
         SUPPORT TABS
    ====================== -->
    <div class="ipm-support-tabs">
        <?php foreach ($support_types as $type): ?>
            <?php if ( ($type['status'] ?? '') === 'active' ): ?>
                <?php
                    $is_active = strtolower($active_type) === strtolower($type['name']);
                    $url = add_query_arg(
                        'type',
                        urlencode($type['name']),
                        get_permalink()
                    );
                ?>
                <a href="<?php echo esc_url($url); ?>"
                   class="ipm-support-tab <?php echo $is_active ? 'active' : ''; ?>">
                    <?php echo esc_html($type['name']); ?>
                </a>
            <?php endif; ?>
        <?php endforeach; ?>
    </div>

    <!-- =====================
         SUPPORT TABLE
    ====================== -->
    <div class="ipm-support-table-wrap">
        <table class="ipm-support-table">
            <thead>
                <tr>
                    <th>Product Name</th>
                    <th>Description</th>
                    <th>Link</th>
                </tr>
            </thead>
            <tbody>

            <?php
            $has_rows = false;

            if ( ! empty($support_items) ):
                foreach ($support_items as $item):

                    if (
                        empty($active_type) ||
                        strtolower($item['type'] ?? '') === strtolower($active_type)
                    ):
                        $has_rows = true;
            ?>
                        <tr>
                            <td>
                                <?php echo esc_html($item['product_name'] ?? '—'); ?>
                            </td>

                            <td>
                                <?php echo wp_kses_post($item['description'] ?? ''); ?>
                            </td>

                            <td>
                                <?php if ( ! empty($item['driver_url']) ): ?>
                                    <a href="<?php echo esc_url($item['driver_url']); ?>"
                                       target="_blank"
                                       rel="noopener noreferrer"
                                       class="ipm-support-link">
                                        Download
                                    </a>
                                <?php else: ?>
                                    —
                                <?php endif; ?>
                            </td>
                        </tr>
            <?php
                    endif;
                endforeach;
            endif;

            if ( ! $has_rows ):
            ?>
                <tr>
                    <td colspan="3" style="text-align:center;">
                        No support data available.
                    </td>
                </tr>
            <?php endif; ?>

            </tbody>
        </table>
    </div>

</div>
