<?php
if (!defined('ABSPATH')) exit;

$items = get_option('ipm_support_type_details', []);

/* DELETE */
if (
    isset($_GET['action'], $_GET['index']) &&
    $_GET['action'] === 'delete' &&
    wp_verify_nonce($_GET['_wpnonce'], 'ipm_delete_support_' . $_GET['index'])
) {
    unset($items[(int)$_GET['index']]);
    update_option('ipm_support_type_details', array_values($items));
    wp_redirect(admin_url('admin.php?page=ipm-support'));
    exit;
}

/* SAVE */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && check_admin_referer('ipm_save_support')) {
    $items[] = [
        'product_name' => sanitize_text_field($_POST['product_name']),
        'type'         => sanitize_text_field($_POST['type']),
        'description'  => wp_kses_post($_POST['description']),
        'driver_url'   => esc_url_raw($_POST['driver_url']),
    ];
    update_option('ipm_support_type_details', $items);
    wp_redirect(admin_url('admin.php?page=ipm-support'));
    exit;
}

$support_types = get_option('ipm_support_types', []);
?>

<div class="wrap">
<h1>Support Links</h1>

<form method="post">
<?php wp_nonce_field('ipm_save_support'); ?>

<table class="form-table">
<tr>
<th>Product Name</th>
<td><input type="text" name="product_name" required></td>
</tr>

<tr>
<th>Type</th>
<td>
<select name="type" required>
<?php foreach ($support_types as $t): ?>
<?php if ($t['status'] === 'active'): ?>
<option value="<?= esc_attr($t['name']) ?>"><?= esc_html($t['name']) ?></option>
<?php endif; endforeach; ?>
</select>
</td>
</tr>

<tr>
<th>Description</th>
<td><?php wp_editor('', 'description', ['textarea_name' => 'description']); ?></td>
</tr>

<tr>
<th>Driver URL</th>
<td><input type="url" name="driver_url"></td>
</tr>
</table>

<?php submit_button('Save Support'); ?>
</form>

<hr>

<table class="widefat striped">
<thead>
<tr>
<th>Product</th>
<th>Type</th>
<th>Description</th>
<th>Action</th>
</tr>
</thead>
<tbody>
<?php if ($items): foreach ($items as $index => $item): ?>
<tr>
<td><?= esc_html($item['product_name']) ?></td>
<td><?= esc_html($item['type']) ?></td>
<td><?= esc_html(wp_trim_words(strip_tags($item['description']), 12)) ?></td>
<td>
 <a href="admin.php?page=ipm-support&action=edit&index=<?= $i ?>">Edit</a> |   
<a href="<?= wp_nonce_url(
    admin_url("admin.php?page=ipm-support&action=delete&index=$index"),
    'ipm_delete_support_' . $index
); ?>">Delete</a>
</td>
</tr>
<?php endforeach; else: ?>
<tr><td colspan="4">No records</td></tr>
<?php endif; ?>
</tbody>
</table>
</div>
