<?php
if (!defined('ABSPATH')) exit;

$items = get_option('ipm_support_type_details', []);

/* ===============================
   HANDLE EDIT STATE
================================ */
$edit_index = null;
$item = null;

if (
    isset($_GET['action'], $_GET['index']) &&
    $_GET['action'] === 'edit'
) {
    $edit_index = (int) $_GET['index'];
    $item = $items[$edit_index] ?? null;
}

/* ===============================
   DELETE
================================ */
if (
    isset($_GET['action'], $_GET['index'], $_GET['_wpnonce']) &&
    $_GET['action'] === 'delete' &&
    wp_verify_nonce($_GET['_wpnonce'], 'ipm_delete_support_' . $_GET['index'])
) {
    unset($items[(int) $_GET['index']]);
    update_option('ipm_support_type_details', array_values($items));

    wp_redirect(admin_url('admin.php?page=ipm-support'));
    exit;
}

/* ===============================
   SAVE (ADD / EDIT)
================================ */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && check_admin_referer('ipm_save_support')) {

    $data = [
        'product_name' => sanitize_text_field($_POST['product_name']),
        'type'         => sanitize_text_field($_POST['type']),
        'description'  => wp_kses_post($_POST['description']),
        'driver_url'   => esc_url_raw($_POST['driver_url']),
    ];

    if ($_POST['support_index'] !== '') {
        // EDIT
        $items[(int) $_POST['support_index']] = $data;
    } else {
        // ADD
        $items[] = $data;
    }

    update_option('ipm_support_type_details', array_values($items));

    wp_redirect(admin_url('admin.php?page=ipm-support'));
    exit;
}

$support_types = get_option('ipm_support_types', []);
?>

<style>
    :root {
        --primary-color: #0073aa;
        --primary-hover: #005a87;
        --danger-color: #d63638;
        --danger-hover: #b32d30;
        --border-color: #dcdcde;
        --bg-light: #f6f7f7;
        --bg-white: #FAFAFA;
        --text-dark: #1e1e1e;
        --text-muted: #646970;
        --shadow-sm: 0 1px 3px rgba(0, 0, 0, 0.08);
        --shadow-md: 0 2px 8px rgba(0, 0, 0, 0.1);
        --radius-sm: 4px;
        --radius-md: 8px;
        --transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
    }

    .ipm-admin-grid {
        display: flex;
        flex-wrap: wrap;
        gap: 24px;
        max-width: 1600px;
    }

    .ipm-col-main {
        flex: 1 1 100%;
        min-width: 0;
    }

    .ipm-card {
        background: var(--bg-white);
        border: 1px solid var(--border-color);
        border-radius: var(--radius-md);
        padding: 24px;
        box-shadow: var(--shadow-sm);
        transition: var(--transition);
    }

    .ipm-card:hover {
        box-shadow: var(--shadow-md);
        border-color: var(--primary-color);
    }

    .ipm-card-title {
        font-size: 14px;
        font-weight: 700;
        color: var(--text-muted);
        text-transform: uppercase;
        letter-spacing: 0.5px;
        margin-bottom: 20px;
        padding-bottom: 12px;
        border-bottom: 2px solid var(--bg-light);
    }

    .ipm-field {
        margin-bottom: 20px;
        display: flex;
        flex-direction: column;
    }

    .ipm-field:last-child {
        margin-bottom: 0;
    }

    .ipm-field label {
        display: block;
        font-size: 14px;
        font-weight: 600;
        color: var(--text-dark);
        margin-bottom: 8px;
        letter-spacing: -0.2px;
    }

    .ipm-field input[type="text"],
    .ipm-field input[type="url"],
    .ipm-field select {
        width: 100%;
        padding: 10px 12px;
        font-size: 14px;
        border: 1px solid var(--border-color);
        border-radius: var(--radius-sm);
        background: var(--bg-white);
        color: var(--text-dark);
        transition: var(--transition);
        font-family: inherit;
    }

    .ipm-field input[type="text"]:focus,
    .ipm-field input[type="url"]:focus,
    .ipm-field select:focus {
        outline: none;
        border-color: var(--primary-color);
        box-shadow: 0 0 0 3px rgba(0, 115, 170, 0.1);
        background: var(--bg-white);
    }

    .wp-editor-wrap {
        margin-top: 8px;
        border: 1px solid var(--border-color);
        border-radius: var(--radius-sm);
        overflow: hidden;
    }

    .ipm-required::after {
        content: '*';
        color: var(--danger-color);
        margin-left: 4px;
        font-weight: 700;
    }

    .button {
        display: inline-flex;
        align-items: center;
        gap: 6px;
        padding: 8px 16px;
        font-size: 14px;
        font-weight: 600;
        border: 1px solid var(--border-color);
        border-radius: var(--radius-sm);
        background: var(--bg-white);
        color: var(--text-dark);
        cursor: pointer;
        transition: var(--transition);
        text-decoration: none;
    }

    .button:hover {
        background: var(--bg-light);
        border-color: var(--primary-color);
        color: var(--primary-color);
    }

    .button-primary {
        background: var(--primary-color);
        color: white;
        border-color: var(--primary-color);
    }

    .button-primary:hover {
        background: var(--primary-hover);
        border-color: var(--primary-hover);
    }

    .button-large {
        padding: 12px 24px;
        font-size: 16px;
        width: 100%;
    }

    .button-danger {
        color: var(--danger-color);
        border-color: var(--danger-color);
    }

    .button-danger:hover {
        background: var(--danger-color);
        color: white;
    }

    .ipm-row {
        display: grid;
        grid-template-columns: 1fr 1fr;
        gap: 16px;
    }

    .ipm-row.full {
        grid-template-columns: 1fr;
    }

    .ipm-submit {
        margin-top: 24px;
        display: flex;
        gap: 12px;
        justify-content: flex-end;
    }

    .ipm-table-wrapper {
        overflow-x: auto;
    }

    .ipm-table {
        width: 100%;
        border-collapse: collapse;
        font-size: 14px;
    }

    .ipm-table thead {
        background: var(--bg-light);
        border-bottom: 2px solid var(--border-color);
    }

    .ipm-table th {
        padding: 12px 16px;
        text-align: left;
        font-weight: 600;
        color: var(--text-dark);
        letter-spacing: -0.2px;
    }

    .ipm-table td {
        padding: 12px 16px;
        border-bottom: 1px solid var(--border-color);
        vertical-align: middle;
    }

    .ipm-table tbody tr:hover {
        background: var(--bg-light);
    }

    .ipm-table-actions {
        display: flex;
        gap: 8px;
        flex-wrap: wrap;
    }

    .ipm-table-actions a {
        display: inline-flex;
        align-items: center;
        padding: 6px 12px;
        font-size: 12px;
        font-weight: 600;
        border: 1px solid var(--border-color);
        border-radius: var(--radius-sm);
        background: var(--bg-white);
        color: var(--text-dark);
        text-decoration: none;
        transition: var(--transition);
    }

    .ipm-table-actions a:hover {
        background: var(--bg-light);
        border-color: var(--primary-color);
        color: var(--primary-color);
    }

    .ipm-table-actions a.delete:hover {
        background: var(--danger-color);
        border-color: var(--danger-color);
        color: white;
    }

    .ipm-empty-state {
        text-align: center;
        padding: 40px 20px;
        color: var(--text-muted);
    }

    .ipm-empty-state p {
        margin: 10px 0;
        font-size: 14px;
    }

    @media (max-width: 768px) {
        .ipm-row {
            grid-template-columns: 1fr;
        }

        .ipm-table {
            font-size: 12px;
        }

        .ipm-table th,
        .ipm-table td {
            padding: 8px 12px;
        }

        .ipm-submit {
            flex-direction: column;
        }

        .button-large {
            width: 100%;
        }
    }

    @keyframes slideIn {
        from {
            opacity: 0;
            transform: translateY(10px);
        }

        to {
            opacity: 1;
            transform: translateY(0);
        }
    }

    .ipm-card {
        animation: slideIn 0.3s ease-out;
    }

    #wpbody-content {
        padding: 0.5rem 1rem;
    }
</style>

<div class="wrap">
    <h1 class="wp-heading-inline">Support Links</h1>
    <a href="<?php echo admin_url('admin.php?page=ipm-support'); ?>" class="page-title-action">
        + Add New
    </a>

    <hr class="wp-header-end">

    <!-- FORM -->
    <?php include IPM_PLUGIN_DIR . 'includes/support/admin/support-form.php'; ?>

    <!-- LIST -->
    <table class="widefat striped" style="margin-top:20px">
        <thead>
            <tr>
                <th>Product</th>
                <th>Type</th>
                <th>Description</th>
                <th width="20%">Action</th>
            </tr>
        </thead>
        <tbody>

        <?php if ($items): ?>
            <?php foreach ($items as $index => $row): ?>
                <tr>
                    <td><strong><?php echo esc_html($row['product_name']); ?></strong></td>
                    <td><?php echo esc_html($row['type']); ?></td>
                    <td><?php echo esc_html(wp_trim_words(strip_tags($row['description']), 12)); ?></td>
                    <td>
                        <a href="<?php echo esc_url(
                            admin_url("admin.php?page=ipm-support&action=edit&index=$index")
                        ); ?>">Edit</a>
                        |
                        <a style="color:red"
                           href="<?php echo wp_nonce_url(
                               admin_url("admin.php?page=ipm-support&action=delete&index=$index"),
                               'ipm_delete_support_' . $index
                           ); ?>"
                           onclick="return confirm('Delete this item?');">
                           Delete
                        </a>
                    </td>
                </tr>
            <?php endforeach; ?>
        <?php else: ?>
            <tr>
                <td colspan="4">No support links found.</td>
            </tr>
        <?php endif; ?>

        </tbody>
    </table>
</div>