<?php
if (!defined('ABSPATH')) exit;
get_header();
$term = get_queried_object();
?>

<main id="primary" class="site-main">

    <!-- ===== PAGE HEADER (OPTIONAL) ===== -->
    <section class="ipm-category-header my-2 my-md-4">
        <div class="container">
            <h1 class="ipm-category-title">
                <?php echo esc_html($term->name); ?>
            </h1>

            <?php if (!empty($term->description)): ?>
                <p class="ipm-category-desc">
                    <?php echo esc_html($term->description); ?>
                </p>
            <?php endif; ?>
        </div>
    </section>

    <!-- ===== PRODUCT GRID ===== -->
    <section class="container ipm-category-products my-2">
        <?php
        $term = get_queried_object();

        $test = get_posts([
            'post_type' => 'ipm_product',
            'tax_query' => [
                [
                    'taxonomy' => 'product_category',
                    'field'    => 'slug',
                    'terms'    => $term->slug,
                ]
            ]
        ]);
        if (empty($test)) {
            echo '<div class="ipm-empty-state">
    <h3>No ' . esc_html($term->name) . ' Currently Available</h3>
    <p>We don\'t have ' . strtolower(esc_html($term->name)) . ' in stock at the moment, but our inventory is frequently updated. Contact our sales team for availability and alternatives.</p>
    <div class="empty-state-actions">
        <a href="' . esc_url(home_url('/contact')) . '" class="btn-primary">Contact Sales</a>

        <a href="' . esc_url(home_url('/our-categories')) . '" class="btn-secondary">Browse Other Categories</a>
    </div>
</div>';
        }
        // echo '<pre>';
        // echo 'Products found: ' . count($test);
        // echo '</pre>';
        echo do_shortcode(
            '[ipm_products category="' . esc_attr($term->slug) . '"]'
        );
        ?>
    </section>

</main>

<?php
get_footer();
