<?php
if (!defined('ABSPATH')) exit;

function ipm_render_product_list($atts = [])
{

    $per_page = 6;
    $paged    = 1;
    $atts = shortcode_atts([
        'category' => '',
    ], $atts);

    $args = [
        'post_type'      => 'ipm_product',
        // 'posts_per_page' => -1,
        'posts_per_page' => 6,
        'paged' => 1,
        'post_status'    => 'publish',
    ];

    // Priority 1: shortcode category
    if (!empty($atts['category'])) {

        $args['tax_query'] = [
            [
                'taxonomy' => 'product_category',
                'field'    => 'slug',
                'terms'    => $atts['category'],
            ]
        ];

        // Priority 2: auto-detect category page
    } elseif (is_tax('product_category')) {

        $term = get_queried_object();

        // if ($term && !empty($term->slug)) {
        $args['tax_query'] = [
            [
                'taxonomy' => 'product_category',
                'field'    => 'slug',
                'terms'    => $term->slug,
            ]
        ];
        // }
    }
    $count_args = $args;
    $count_args['posts_per_page'] = -1;
    $count_args['fields'] = 'ids';
    $total_products = count(get_posts($count_args));
    $products = get_posts($args);
    if (!$products) return '';

    ob_start();
?>
    <style>
        /* GRID WRAPPER */
        .ipm-products-grid {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 24px;
            max-width: 1400px;
            margin: 0 auto;
            padding: 40px 16px;
        }

        /* PRODUCT CARD */
        .ipm-product-card {
            background: #fff;
            border: 1px solid #e5e7eb;
            border-radius: 10px;
            overflow: hidden;
            box-shadow: 0 4px 14px rgba(0, 0, 0, 0.06);
            transition: all 0.3s ease;
        }

        .ipm-product-card:hover {
            transform: translateY(-4px);
            box-shadow: 0 10px 30px rgba(0, 0, 0, 0.12);
        }

        /* IMAGE */
        .ipm-product-image img {
            width: 100%;
            height: 400px;
            object-fit: cover;
            display: block;
        }

        /* CONTENT */
        .ipm-product-content {
            padding: 18px;
        }

        .ipm-product-title {
            font-size: 18px;
            font-weight: 600;
            margin: 0 0 8px;
        }

        .ipm-product-title a {
            color: #111827;
            text-decoration: none;
        }

        .ipm-product-desc {
            font-size: 14px;
            color: #6b7280;
            line-height: 1.6;
            margin-bottom: 16px;
        }

        /* BUTTON */
        .ipm-product-btn {
            display: inline-block;
            padding: 0 14px;
            background: var(--interlink-accent-color);
            color: white;
            font-size: 14px;
            border-radius: 25px;
            text-decoration: none;
        }

        .ipm-product-btn:hover {
            background: var(--interlink-secondary-color);
            color: white;
        }


        /* Tablet */
        @media (max-width: 1024px) {
            .ipm-products-grid {
                grid-template-columns: repeat(2, 1fr);
            }
        }

        /* Mobile */
        @media (max-width: 640px) {
            .ipm-products-grid {
                grid-template-columns: 1fr;
            }

            .ipm-product-image img {
                height: 300px;
            }
        }
    </style>

    <div class="ipm-products-grid"
     id="ipm-products-grid"
     data-category="<?php echo esc_attr($atts['category'] ?: ($term->slug ?? '')); ?>">
        <?php foreach ($products as $product): ?>
            <div class="ipm-product-card">

                <a href="<?php echo esc_url(get_permalink($product->ID)); ?>" class="ipm-product-image">
                    <?php
                    if (has_post_thumbnail($product->ID)) {
                        echo get_the_post_thumbnail($product->ID, 'medium');
                    } else {
                    ?>
                        <div class="ipm-product-placeholder" style="width: 100%; aspect-ratio: 1; background: linear-gradient(135deg, #f5f5f5 0%, #e8e8e8 100%); display: flex; align-items: center; justify-content: center; color: #999; font-size: 13px; font-weight: 500; letter-spacing: 0.5px;">
                            NO IMAGE
                        </div>
                    <?php
                    }
                    ?>

                </a>

                <div class="ipm-product-content">
                    <h3 class="ipm-product-title text-truncate">
                        <a href="<?php echo esc_url(get_permalink($product->ID)); ?>">
                            <?php echo esc_html($product->post_title); ?>
                        </a>
                    </h3>

                    <p class="ipm-product-desc">
                        <?php echo esc_html(wp_trim_words($product->post_content, 18)); ?>
                    </p>

                    <a href="<?php echo esc_url(get_permalink($product->ID)); ?>"
                        class="ipm-product-btn">
                        View Details →
                    </a>
                </div>

            </div>
        <?php endforeach; ?>
    </div>
    <div id="ipm-scroll-loader" style="text-align:center; padding:20px; display:none;">
        Loading more products…
    </div>



<?php
    return ob_get_clean();
}

add_shortcode('ipm_products', 'ipm_render_product_list');
