<?php
if (!defined('ABSPATH')) exit;

add_shortcode('interlink_product_categories', function () {

    ob_start();

    /* =========================
     * 1. Load product categories
     * ========================= */
    $terms = get_terms([
        'taxonomy'   => 'product_category',
        'hide_empty' => false,
    ]);

    if (is_wp_error($terms) || empty($terms)) {
        return '';
    }

    /* =========================
     * 2. Load saved status + order
     * ========================= */
    $status_map = get_option('interlink_category_list', []);
    $order_map  = get_option('interlink_category_order', []);

    $categories = [];

    /* =========================
     * 3. Apply conditions safely
     * ========================= */
    foreach ($terms as $term) {

        // Safety
        if (empty($term->term_id) || empty($term->slug)) {
            continue;
        }

        // Skip Uncategorized
        if ($term->slug === 'uncategorized') {
            continue;
        }

        // Skip draft categories
        $status = $status_map[$term->slug]['status'] ?? 'active';

        if ($status !== 'active') {
            continue;
        }

        $image = get_term_meta($term->term_id, 'category_image', true);

        // Skip broken cards
        if (empty($term->name)) {
            continue;
        }

        $categories[] = [
            'term_id'     => $term->term_id,
            'name'        => $term->name,
            'slug'        => $term->slug,
            'description' => $term->description,
            'image'       => $image,
        ];
    }

    if (empty($categories)) {
        return '';
    }

    /* =========================
     * 4. Apply drag & drop order
     * ========================= */
    usort($categories, function ($a, $b) use ($order_map) {
        return ($order_map[$a['slug']] ?? 999) <=> ($order_map[$b['slug']] ?? 999);
    });

    /* =========================
     * 5. Column logic (same)
     * ========================= */
    $count     = count($categories);
    // $col_class = ($count > 3) ? 'col-md-3' : 'col-md-4';
    $col_class = 'col-md-4';
    $is_home_page = is_front_page() || is_home();
    $max_items    = $is_home_page ? 6 : count($categories);
    ?>

    <!-- ===== HTML STRUCTURE (UNCHANGED) ===== -->
    <div class="container my-4">
        <div class="row g-4">

            <?php foreach (array_slice($categories, 0, $max_items) as $cat): ?>
                <div class="<?= esc_attr($col_class) ?> col-sm-6 col-12">
                    <div class="te-info-card style-2">
                        <div class="te-info-card-inner mb-2">
                            <?php if (!empty($cat['image'])): ?>
                                <img
                                    src="<?= esc_url($cat['image']) ?>"
                                    class="card-img-top"
                                    alt="<?= esc_attr($cat['name']) ?>">
                            <?php endif; ?>
                        </div>

                        <div class="te-content-wrapper">
                            <div class="te-title-wrapper">
                                <h2 class="title">
                                    <a href="<?= esc_url(get_term_link($cat['term_id'], 'product_category')) ?>">
                                        <?= esc_html($cat['name']) ?>
                                    </a>
                                </h2>
                            </div>

                            <div class="content">
                                <?php if (!empty($cat['description'])): ?>
                                    <p class="desc">
                                        <?= esc_html(wp_trim_words($cat['description'], 11)) ?>
                                    </p>
                                <?php endif; ?>

                                <div class="te-read-more">
                                    <a href="<?= esc_url(get_term_link($cat['term_id'], 'product_category')) ?>"
                                       class="te-theme-btn">
                                        All Products View <i class="fa fa-solid fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; ?>

        </div>

        <?php if($is_home_page && $count > 6): ?>
            <div class="text-center">
                <a href="#" class="te-theme-btn">
                    Load More <i class="fa fa-solid fa-arrow-right"></i>
                </a>
            </div>
        <?php endif; ?>

    </div>


    
    <?php
    return ob_get_clean();
});
