<?php
if (!defined('ABSPATH')) {
    exit;
}

add_filter('the_title', function ($title) {
    if (is_tax('product_category') && in_the_loop() && is_main_query()) {
        $term = get_queried_object();
        return esc_html($term->name);
    }
    return $title;
}, 10);


add_filter('document_title_parts', function ($title) {
    if (is_tax('product_category')) {
        $term = get_queried_object();
        $title['title'] = $term->name . ' | Scanlife';
    }
    return $title;
});
add_action('wp_enqueue_scripts', function () {

    if (!is_tax('product_category')) {
        return;
    }

    wp_add_inline_script(
        'jquery',
        "
        document.addEventListener('DOMContentLoaded', function () {

            if (!window.location.pathname.includes('/product-category/')) {
                return;
            }

            document.querySelectorAll('.te-breadcrumb-list a, .te-breadcrumb-list span')
                .forEach(function (el) {
                    if (el.textContent.trim().toLowerCase() === 'blog') {
                        el.textContent = 'Category';
                    }
                });
        });
        "
    );
});

?>


