document.addEventListener('DOMContentLoaded', function () {
    
    const popup = document.getElementById('ipm-quote-popup');
    const openBtns = document.querySelectorAll('.ipm-open-quote');
    const closeBtn = popup?.querySelector('.ipm-popup-close');

    if (!popup) return;

    openBtns.forEach(btn => {
        btn.addEventListener('click', function () {
            popup.classList.add('is-active');
            popup.setAttribute('aria-hidden', 'false');
        });
    });

    closeBtn.addEventListener('click', closePopup);
    popup.addEventListener('click', function (e) {
        if (e.target === popup) closePopup();
    });

    document.addEventListener('keydown', function (e) {
        if (e.key === 'Escape') closePopup();
    });

    function closePopup() {
        popup.classList.remove('is-active');
        popup.setAttribute('aria-hidden', 'true');
    }
});
