jQuery(function ($) {

    let page = 2;
    let loading = false;
    let finished = false;

    const grid = $('#ipm-products-grid');
    const loader = $('#ipm-scroll-loader');

    if (!grid.length) return;

    const category = grid.data('category');

    function loadMoreProducts() {

        if (loading || finished) return;

        loading = true;
        loader.show();

        $.ajax({
            url: ipm_ajax.ajax_url,
            type: 'POST',
            data: {
                action: 'ipm_load_more_products',
                page: page,
                category: category
            },
            success: function (res) {

                if (!res.success || res.data.end) {
                    finished = true;
                    loader.hide();
                    return;
                }

                grid.append(res.data.html);
                page++;
                loading = false;
                loader.hide();
            }
        });
    }

    $(window).on('scroll', function () {
        if (
            $(window).scrollTop() + $(window).height() >
            grid.offset().top + grid.outerHeight() - 300
        ) {
            loadMoreProducts();
        }
    });

});
