<?php
if (!defined('ABSPATH')) exit;

class IPM_Assets {

    public static function init_admin() {
        add_action('admin_enqueue_scripts', [__CLASS__, 'enqueue_admin']);
    }
    public static function init_frontend() {

        add_action('wp_enqueue_scripts', function () {

            // Load ONLY on frontend product/category pages
            if (
                is_tax('product_category') ||
                is_singular('ipm_product') ||
                has_shortcode(get_post_field('post_content', get_queried_object_id()), 'ipm_products')
            ) {
            wp_enqueue_style(
                'interlink-products-style',
                IPM_PLUGIN_URL . 'includes/frontend/assets/css/interlink-style.css',
                [],
                '1.0.0'
            );

            // Load More JS
             add_action('wp_enqueue_scripts', [__CLASS__, 'enqueue_frontend']);
             
            wp_enqueue_script(
                'ipm-load-more',
                IPM_PLUGIN_URL . 'includes/frontend/assets/js/ipm-load-more.js',
                ['jquery'],
                '1.0.0',
                true
            );
            
            wp_enqueue_script(
                'ipm-accordion',
                IPM_PLUGIN_URL . 'includes/frontend/assets/js/ipm-accordion.js',
                ['jquery'],
                '1.0.0',
                true
            );

            wp_enqueue_script(
                'ipm-popup',
                IPM_PLUGIN_URL . 'includes/frontend/assets/js/ipm-popup.js',
                ['jquery'],
                '1.0.0',
                true
            );

            // wp_enqueue_style(
            //     'slick-css',
            //     'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.css'
            // );

            // wp_enqueue_style(
            //     'slick-theme-css',
            //     'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick-theme.css'
            // );

            // wp_enqueue_script(
            //     'slick-js',
            //     'https://cdn.jsdelivr.net/npm/slick-carousel@1.8.1/slick/slick.min.js',
            //     ['jquery'],
            //     '1.8.1',
            //     true
            // );

            wp_enqueue_script(
                'ipm-slider-products',
                IPM_PLUGIN_URL . 'includes/frontend/assets/js/ipm-slider-products.js',
                ['jquery'],
                '1.0.0',
                true
            );

            wp_localize_script('ipm-load-more', 'ipm_ajax', [
                'ajax_url' => admin_url('admin-ajax.php')
            ]);
            }
        });
        
    }
    public static function enqueue_admin($hook) {
        // Categories page
        if ($hook === 'products-management_page_ipm-categories') {

            wp_enqueue_media();
            wp_enqueue_script('jquery-ui-sortable');

            wp_localize_script('jquery', 'ipmCategory', [
                'nonce' => wp_create_nonce('ipm_category_nonce')
            ]);
        }

        // Only load media on Add/Edit screen
        if ($hook !== 'toplevel_page_ipm-products') {
            return;
        }
        // Clients page
        if ($hook === 'ipm-products_page_ipm-clients') {

            wp_enqueue_media();
            wp_enqueue_script('jquery-ui-sortable');

            wp_localize_script('jquery', 'ipmClient', [
                'nonce' => wp_create_nonce('save_client_partners')
            ]);
        }

        // Load media ONLY when form is visible (add/edit)
        if (!isset($_GET['edit']) && !isset($_GET['add'])) {
            return;
        }

        wp_enqueue_media();

        wp_enqueue_script(
            'ipm-admin-media',
            IPM_PLUGIN_URL . 'includes/assets/js/ipm-admin-media.js',
            ['jquery', 'media-editor'],
            '1.0',
            true
        );
    }

}
