<?php
if (!defined('ABSPATH')) exit;

/* =========================
   LOAD EDIT DATA (IF ANY)
========================= */
$edit_id = intval($_GET['edit'] ?? 0);
$product = $edit_id ? get_post($edit_id) : null;

$meta = function ($key) use ($edit_id) {
    return $edit_id ? get_post_meta($edit_id, $key, true) : '';
};

$categories = get_terms([
    'taxonomy'   => 'product_category',
    'hide_empty' => false
]);
?>
<style>
iframe{
    height: 200px !important;
}
/* Title */
.ipm-form-title {
    margin: 20px 0 16px;
    font-size: 22px;
    font-weight: 600;
}

/* Grid Layout */
.ipm-admin-grid {
    display: grid;
    grid-template-columns: 2.2fr 1fr;
    gap: 24px;
    max-width: 1400px;
}

/* Columns */
.ipm-col {
    min-width: 0;
}

/* Fields */
.ipm-field {
    margin-bottom: 18px;
}

.ipm-field label {
    display: block;
    font-weight: 600;
    margin-bottom: 6px;
}

.ipm-field input[type="text"],
.ipm-field input[type="url"],
.ipm-field select,
.ipm-field textarea {
    width: 100%;
    max-width: 100%;
}

/* Editor spacing */
.wp-editor-wrap {
    margin-top: 6px;
}

/* Sidebar cards */
.ipm-col-sidebar {
    background: #f6f7f7;
    padding: 16px;
    border-radius: 6px;
    border: 1px solid #dcdcde;
}

/* Media Preview */
.ipm-preview {
    margin-top: 10px;
}

.ipm-preview img {
    max-width: 120px;
    height: auto;
    border-radius: 4px;
    border: 1px solid #ccd0d4;
}

/* Upload buttons */
.ipm-upload {
    margin-top: 4px;
}

/* Submit */
.ipm-submit {
    margin-top: 24px;
    padding-top: 16px;
}
.ipm-submit-right {
    margin-top: 10px;
    padding-top: 0px;
    text-align: right;
}

/* Required indicator */
.ipm-required::after {
    content: '*';
    color: #d63638;
    margin-left: 4px;
}

/* Responsive */
@media (max-width: 1100px) {
    .ipm-admin-grid {
        grid-template-columns: 1fr;
    }

    .ipm-col-sidebar {
        padding: 14px;
    }
}
</style>

</style>
<h2 class="ipm-form-title">
    <?php echo $edit_id ? 'Edit Product' : 'Add New Product'; ?>
</h2>

<form method="post">

<?php wp_nonce_field('ipm_save_product', '_ipm_product_nonce'); ?>
<input type="hidden" name="product_id" value="<?php echo esc_attr($edit_id); ?>">

<div class="ipm-admin-grid">

<!-- ================= LEFT COLUMN ================= -->
<div class="ipm-col ipm-col-main">

    <!-- Product Name -->
    <div class="ipm-field">
        <div>
        <label>Product Name *</label>
        <input type="text"
               name="product_title"
               required
               value="<?php echo esc_attr($product->post_title ?? ''); ?>">
        </div>
        <div>
               <label>Product Category</label>
        <select name="product_category">
            <option value="">— Select —</option>
            <?php foreach ($categories as $cat): ?>
                <option value="<?php echo esc_attr($cat->term_id); ?>"
                    <?php
                    if ($edit_id) {
                        $terms = wp_get_post_terms($edit_id, 'product_category', ['fields'=>'ids']);
                        selected(in_array($cat->term_id, $terms));
                    }
                    ?>>
                    <?php echo esc_html($cat->name); ?>
                </option>
            <?php endforeach; ?>
        </select>
        </div>
    </div>
     <!-- Category -->
    <div class="ipm-field">
        
    </div>


    <!-- Product Description -->
    <div class="ipm-field">
        <label>Product Description</label>
        <?php wp_editor($product->post_content ?? '', 'product_description'); ?>
    </div>

    <!-- Product Features -->
    <div class="ipm-field">
        <label>Product Features</label>
        <?php wp_editor($meta('product_features'), 'product_features'); ?>
    </div>

    <!-- Warranty -->
    <div class="ipm-field">
        <label>Warranty Details</label>
        <?php wp_editor($meta('warranty_details'), 'warranty_details'); ?>
    </div>

    <!-- Accessories -->
    <div class="ipm-field">
        <label>Accessories</label>
        <?php wp_editor($meta('accessories'), 'accessories'); ?>
    </div>

</div>

<!-- ================= RIGHT COLUMN ================= -->
<div class="ipm-col ipm-col-sidebar">

    <!-- Status -->
    <div class="ipm-field">
        <label>Product Status</label>
        <select name="product_status">
            <option value="publish" <?php selected($product->post_status ?? '', 'publish'); ?>>Active</option>
            <option value="draft" <?php selected($product->post_status ?? '', 'draft'); ?>>Draft</option>
        </select>
         <p class="ipm-submit-right">
            <button type="submit" name="ipm_save_product" class="button button-primary button-large">
                <?php echo $edit_id ? 'Update Product' : 'Save Product'; ?>
            </button>
        </p>
    </div>

   
    <!-- Featured Image -->
    <div class="ipm-field">
        <label>Featured Image</label>
        <input type="hidden" name="featured_image_id" id="featured_image_id"
               value="<?php echo esc_attr(get_post_thumbnail_id($edit_id)); ?>">
        <button type="button" class="button ipm-upload" data-target="featured_image_id">
            Upload Featured Image
        </button>
        <div class="ipm-preview">
            <?php echo $edit_id ? get_the_post_thumbnail($edit_id, [120,120]) : ''; ?>
        </div>
    </div>

    <!-- Gallery Images -->
    <div class="ipm-field">
        <label>Gallery Images</label>
        <?php for ($i=1; $i<=3; $i++): ?>
            <input type="hidden"
                   name="gallery_image_<?php echo $i; ?>"
                   id="gallery_image_<?php echo $i; ?>"
                   value="<?php echo esc_attr($meta('gallery_image_'.$i)); ?>">
            <button type="button"
                    class="button ipm-upload"
                    data-target="gallery_image_<?php echo $i; ?>">
                Gallery Image <?php echo $i; ?>
            </button><br><br>
        <?php endfor; ?>
    </div>

    <!-- Dimensions -->
    <div class="ipm-field">
        <label>Product Dimensions</label>
        <input type="text"
               name="product_dimension"
               value="<?php echo esc_attr($meta('product_dimension')); ?>">
    </div>

    <!-- PDF -->
    <div class="ipm-field">
        <label>PDF Catalog Link</label>
        <input type="url"
               name="product_pdf"
               placeholder="https://example.com/catalog.pdf"
               value="<?php echo esc_url($meta('product_pdf')); ?>">
    </div>

    <!-- YouTube -->
    <div class="ipm-field">
        <label>YouTube Embed Link</label>
        <input type="url"
               name="youtube_url"
               placeholder="https://www.youtube.com/watch?v=xxxx"
               value="<?php echo esc_url($meta('youtube_url')); ?>">
    </div>

    <!-- SEO -->
    <div class="ipm-field">
        <label>Meta Slug</label>
        <input type="text"
               name="meta_slug"
               value="<?php echo esc_attr($meta('meta_slug')); ?>">
    </div>

    <div class="ipm-field">
        <label>Meta Title</label>
        <input type="text"
               name="meta_title"
               value="<?php echo esc_attr($meta('meta_title')); ?>">
    </div>

    <div class="ipm-field">
        <label>Meta Description</label>
        <textarea name="meta_description" rows="3"><?php echo esc_textarea($meta('meta_description')); ?></textarea>
    </div>

    <div class="ipm-field">
        <label>Meta Keywords</label>
        <input type="text"
               name="meta_keywords"
               value="<?php echo esc_attr($meta('meta_keywords')); ?>">
    </div>

</div>
</div>

<p class="ipm-submit">
    <button type="submit" name="ipm_save_product" class="button button-primary button-large">
        <?php echo $edit_id ? 'Update Product' : 'Save Product'; ?>
    </button>
</p>

</form>
