<?php
if (!defined('ABSPATH')) exit;
/* =========================
   ADMIN PAGE
========================= */
function interlink_client_partner_admin_page()
{
    $partners = get_option('interlink_client_partners', []);

    /* ---------- SAVE ---------- */
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && check_admin_referer('save_client_partners', 'client_partner_nonce')) {

        $submitted = $_POST['partners'] ?? [];
        $clean = [];
        $seen = [];

        foreach ($submitted as $p) {

            if (empty($p['name'])) {
                continue;
            }

            $name = sanitize_text_field($p['name']);
            $slug = sanitize_title($name);

            // Prevent duplicate names
            if (isset($seen[$slug])) {
                continue;
            }
            $seen[$slug] = true;

            $clean[] = [
                'name'   => $name,
                'slug'   => $slug,
                'logo'   => esc_url_raw($p['logo'] ?? ''),
                'status' => sanitize_text_field($p['status'] ?? 'active'),
            ];
        }

        $submitted = $_POST['partners'] ?? [];
        update_option('interlink_client_partners', array_values($clean));

        echo '<div class="updated notice"><p>Client partners saved successfully.</p></div>';
    }
?>

    <style>
        .wrap {
            background: #FAFAFA;
            padding: 16px;
        }

        .logo-preview img {
            max-width: 80px;
            border: 1px solid #ddd;
            border-radius: 4px;
        }

        .remove-partner {
            background: none;
            border: none;
            color: #cc1818;
            cursor: pointer;
            font-size: 16px;
        }

        #client-partner-sort tr {
            cursor: move;
        }

        #client-partner-sort .handle {
            cursor: grab;
            margin-right: 8px;
            color: #555;
        }

        #client-partner-sort tr.ui-sortable-helper {
            background: #f1f5f9;
        }
    </style>

    <div class="wrap">
        <h1>Client Partner Management</h1>

        <form method="post">
            <?php wp_nonce_field('save_client_partners', 'client_partner_nonce'); ?>

            <table class="form-table">
                <thead>
                    <tr>
                        <th>Client Name</th>
                        <th>Logo</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody id="client-partner-sort">
                    <?php foreach ($partners as $i => $p): ?>
                        <tr>
                            <td>
                                <input type="text"
                                    name="partners[<?= $i ?>][name]"
                                    value="<?= esc_attr($p['name']) ?>"
                                    required>
                            </td>

                            <td>
                                <div class="logo-preview">
                                    <?php if (!empty($p['logo'])): ?>
                                        <img src="<?= esc_url($p['logo']) ?>">
                                    <?php endif; ?>
                                </div>
                                <input type="hidden"
                                    name="partners[<?= $i ?>][logo]"
                                    value="<?= esc_url($p['logo']) ?>">
                                <button type="button" class="button select-logo">
                                    🖼️ Select Logo
                                </button>
                            </td>

                            <td>
                                <select name="partners[<?= $i ?>][status]">
                                    <option value="active" <?php selected($p['status'], 'active'); ?>>📌 Active</option>
                                    <option value="draft" <?php selected($p['status'], 'draft'); ?>>📝 Draft</option>
                                </select>
                            </td>

                            <td>
                                <span class="dashicons dashicons-move handle" title="Drag"></span>
                                <button type="button" class="remove-partner"><i class="dashicons dashicons-trash"></i></button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <p style="text-align:center">
                <button type="button" class="button" id="add-partner">+ Add Client</button>
                <input type="submit" class="button-primary" value="Save Clients">
            </p>
        </form>
    </div>

    <script>
        jQuery(function($) {

            jQuery(document).ready(function($) {
                if ($('#client-partner-sort').length) {

                    $('#client-partner-sort').sortable({
                        handle: '.handle',
                        axis: 'y',
                        placeholder: 'ui-sortable-placeholder'
                    });

                }
            });


            /* Logo upload */
            $(document).on('click', '.select-logo', function() {
                let btn = $(this);
                let input = btn.prev('input');
                let preview = btn.prevAll('.logo-preview');

                let frame = wp.media({
                    title: 'Select Logo',
                    button: {
                        text: 'Use Logo'
                    },
                    multiple: false
                });

                frame.on('select', function() {
                    let file = frame.state().get('selection').first().toJSON();
                    input.val(file.url);
                    preview.html('<img src="' + file.url + '">');
                });

                frame.open();
            });

            /* Add new row */
            $('#add-partner').on('click', function() {
                let index = $('tbody tr').length;

                let row = `
        <tr>
            <td><input type="text" name="partners[${index}][name]" required></td>
            <td>
                <div class="logo-preview"></div>
                <input type="hidden" name="partners[${index}][logo]">
                <button type="button" class="button select-logo">🖼️ Select Logo</button>
            </td>
            <td>
                <select name="partners[${index}][status]">
                    <option value="active">📌 Active</option>
                    <option value="draft">📝 Draft</option>
                </select>
            </td>
            <td>
             <span class="dashicons dashicons-move handle" title="Drag"></span>
                <button type="button" class="remove-partner"><i class="dashicons dashicons-trash"></i></button>
            </td>
        </tr>
        `;

                $('tbody').append(row);
            });

            /* Remove row */
            $(document).on('click', '.remove-partner', function() {
                if (confirm('Remove this client?')) {
                    $(this).closest('tr').remove();
                }
            });

        });
    </script>

<?php } ?>