<?php
if (!defined('ABSPATH')) exit;

/* =========================
   ADMIN PAGE RENDER
========================= */
function interlink_category_list_admin_page()
{
    /* ---------- Load terms ---------- */
    $terms = get_terms([
        'taxonomy'   => 'product_category',
        'hide_empty' => false,
    ]);
    if (is_wp_error($terms) || !is_array($terms)) {
        $terms = [];
    }
    $status_map = get_option('interlink_category_list', []);
    $order_map  = get_option('interlink_category_order', []);
    $categories = [];
    foreach ($terms as $term) {

        // 🔒 Ensure WP_Term object
        if (!($term instanceof WP_Term)) {
            continue;
        }
        $slug = $term->slug;

        $categories[] = [
            'term_id'     => $term->term_id,
            'name'        => $term->name,
            'description' => $term->description,
            'image'       => get_term_meta($term->term_id, 'category_image', true),
            'status'      => $status_map[$slug]['status'] ?? 'active',
            'slug'        => $slug,
        ];
    }

    // Apply saved order
    usort($categories, function ($a, $b) use ($order_map) {
        return ($order_map[$a['slug']] ?? 999) <=> ($order_map[$b['slug']] ?? 999);
    });


?>

    <style>
        #sortable-categories tr {
            cursor: move;
        }

        .remove-category {
            color: #cc1818;
            border: none;
            background: none;
            cursor: pointer
        }

        .image-preview-wrapper img {
            max-width: 70px;
        }

        /* ===== Admin Wrapper ===== */
        .wrap {
            background: #FAFAFA;
            padding: 16px;
            box-shadow: 0 4px 6px rgba(0, 0, 0, 0.1);
            border-radius: 6px;
        }

        /* ===== Table Styling ===== */
        .form-table {
            background: #ffffff;
            border-collapse: collapse;
            width: 100%;
        }

        .form-table th {
            padding: 12px;
            font-weight: 600;
            background: #f1f5f9;
            border-bottom: 1px solid #d0d7de;
        }

        .form-table td {
            padding: 12px;
            vertical-align: top;
            border-bottom: 1px solid #e5e7eb;
        }

        /* ===== Drag & Drop Indicator ===== */
        #sortable-categories tr {
            cursor: move;
        }

        #sortable-categories tr:hover {
            background: #f9fafb;
        }

        /* ===== Inputs ===== */
        .form-table input[type="text"],
        .form-table textarea,
        .form-table select {
            width: 100%;
            max-width: 100%;
        }

        .form-table textarea {
            resize: vertical;
        }

        /* ===== Image Preview ===== */
        .image-preview-wrapper {
            margin-bottom: 6px;
        }

        .image-preview-wrapper img {
            max-width: 70px;
            max-height: 70px;
            border-radius: 4px;
            border: 1px solid #d1d5db;
            background: #fff;
        }

        /* ===== Buttons ===== */
        button.select-category-image {
            background: #2271b1;
            color: #ffffff;
            border: none;
        }

        button.select-category-image:hover {
            background: #1d4ed8;
            color: #ffffff;
        }

        /* ===== Delete Button ===== */
        .remove-category {
            background: transparent !important;
            border: none !important;
            color: #cc1818 !important;
            cursor: pointer;
            padding: 4px;
            font-size: 16px;
        }

        .remove-category:hover {
            color: #9f1239 !important;
        }

        /* ===== Action Area ===== */
        .wrap p {
            margin-top: 16px;
        }

        /* ===== Notices ===== */
        .notice.updated {
            border-left-color: #16a34a;
        }

        .w-100 {
            width: 100% !important;
        }
    </style>
    <?php
    if (isset($_GET['saved'])) {
        echo '<div class="notice notice-success is-dismissible">';
        echo '<p>✅ <strong>' . intval($_GET['saved']) . '</strong> categories saved successfully.</p>';
        echo '</div>';
    }
    ?>
    <div class="wrap">
        <h1>Manage Categories</h1>

        <form method="post" action="<?php echo admin_url('admin-post.php'); ?>">
            <input type="hidden" name="action" value="ipm_save_categories">

            <?php wp_nonce_field('save_category_list', 'category_list_nonce'); ?>

            <table class="form-table">
                <thead>
                    <tr>
                        <th>Name</th>
                        <th style="width:40%">Short Description</th>
                        <th>Image</th>
                        <th>Status</th>
                        <th>Action</th>
                    </tr>
                </thead>

                <tbody id="sortable-categories">
                    <?php foreach ($categories as $i => $cat): ?>
                        <tr>
                            <td>
                                <input type="text" name="categories[<?= $i ?>][name]" value="<?= esc_attr($cat['name']) ?>" required>
                                <input type="hidden" name="categories[<?= $i ?>][slug]" value="<?= esc_attr($cat['slug']) ?>">
                                <input type="hidden" name="categories[<?= $i ?>][term_id]" value="<?= esc_attr($cat['term_id']) ?>">
                            </td>

                            <td>
                                <textarea name="categories[<?= $i ?>][description]" rows="2"><?= esc_textarea($cat['description']) ?></textarea>
                            </td>

                            <td>
                                <div class="image-preview-wrapper">
                                    <img src="<?= esc_url($cat['image']) ?>">
                                </div>
                                <input type="hidden" name="categories[<?= $i ?>][image]" value="<?= esc_url($cat['image']) ?>">
                                <button type="button" class="button select-category-image w-100">🖼️ Upload Image</button>
                                <span style="font-size: 13px;"><b>Note:</b> Image Size Should Be W:1080px to H:1080px</span>
                            </td>

                            <td>
                                <select name="categories[<?= $i ?>][status]">
                                    <option value="active" <?php selected($cat['status'], 'active'); ?>>📌 Active</option>
                                    <option value="draft" <?php selected($cat['status'], 'draft'); ?>>📝 Draft</option>
                                </select>
                            </td>

                            <td>
                                <button type="button" class="remove-category" data-term="<?= esc_attr($cat['term_id']) ?>" data-slug="<?= esc_attr($cat['slug']) ?>"><i class="dashicons dashicons-trash"></i></button>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>

            <p style="text-align:center">
                <button type="button" class="button" id="add-category">+ Add Category</button>
                <input type="submit" class="button-primary" value="Save Categories">
            </p>
        </form>
    </div>

    <script>
        jQuery(function($) {
            // ADD CATEGORY ROW
            $('#add-category').on('click', function() {

                let index = $('#sortable-categories tr').length;

                let row = `<tr>
        <td>
            <input type="text" name="categories[${index}][name]" required>
            <input type="hidden" name="categories[${index}][slug]">
            <input type="hidden" name="categories[${index}][term_id]" value="">
        </td>

        <td>
            <textarea name="categories[${index}][description]" rows="2"></textarea>
        </td>

        <td>
            <div class="image-preview-wrapper">
                <img src="">
            </div>
            <input type="hidden" name="categories[${index}][image]">
            <button type="button" class="button select-category-image w-100">🖼️ Upload Image</button>
            <span style="font-size: 13px;"><b>Note:</b> Image Size Should Be W:1080px to H:1080px</span>
        </td>

        <td>
            <select name="categories[${index}][status]">
                <option value="active">📌 Active</option>
                <option value="draft">📝 Draft</option>
            </select>
        </td>

        <td>
            <button type="button" class="remove-category"><i class="dashicons dashicons-trash"></i></button>
        </td>
    </tr>
    `;

                $('#sortable-categories').append(row);
            });

            // Media picker
            $(document).on('click', '.select-category-image', function() {
                let btn = $(this);
                let input = btn.prev('input');
                let img = btn.prevAll('.image-preview-wrapper').find('img');

                let frame = wp.media({
                    title: 'Select Image',
                    button: {
                        text: 'Use'
                    },
                    multiple: false
                });

                frame.on('select', function() {
                    let file = frame.state().get('selection').first().toJSON();
                    input.val(file.url);
                    img.attr('src', file.url);
                });

                frame.open();
            });

            // Delete
            $('.remove-category').on('click', function() {

                let row = $(this).closest('tr');
                let termId = row.find('input[name*="[term_id]"]').val();

                // If new row → just remove
                if (!termId) {
                    row.remove();
                    return;
                }

                if (!confirm('Delete this category permanently?')) return;

                $.post(ajaxurl, {
                    action: 'ipm_delete_category',
                    term_id: termId,
                    slug: row.find('input[name*="[slug]"]').val(),
                    _wpnonce: ipmCategory.nonce
                }, function(res) {
                    if (res.success) {
                        row.remove();
                    }
                });
            });


            // Drag & Drop
            $('#sortable-categories').sortable({
                update: function() {
                    let order = {};
                    $('#sortable-categories tr').each(function(i) {
                        let slug = $(this).find('input[name*="[slug]"]').val();
                        order[slug] = i + 1;
                    });

                    $.post(ajaxurl, {
                        action: 'ipm_save_category_order',
                        order: order,
                        _wpnonce: ipmCategory.nonce
                    });
                }
            });
        });
    </script>

<?php } ?>