<?php
namespace EkobyteCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Ekobyte Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Ekobyte_Testimonial extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'ekobyte-testimonial';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Ekobyte Testimonial', 'ekobytecore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'ekobyte-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        /**
         * Layout section
         */
        $this->start_controls_section(
            'ekobyte_layout',
            [
                'label' => esc_html__('Design Layout', 'ekobytecore'),
            ]
        );
        $this->add_control(
            'ekobyte_design_style',
            [
                'label' => esc_html__('Select Layout', 'ekobytecore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'ekobytecore'),
                    'layout-2' => esc_html__('Layout 2', 'ekobytecore'),
                    'layout-3' => esc_html__('Layout 3', 'ekobytecore'),
                ],
                'default' => 'layout-1',
            ]
        );
        $this->end_controls_section();


        /**
         * Title and content section
         */
        $this->start_controls_section(
            'ekobyte_section_title',
            [
                'label' => esc_html__('Title & Content', 'ekobytecore'),
            ]
        );

        $this->add_control(
            'ekobyte_section_title_show',
            [
                'label' => esc_html__( 'Section Title & Content', 'ekobytecore' ),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__( 'Show', 'ekobytecore' ),
                'label_off' => esc_html__( 'Hide', 'ekobytecore' ),
                'return_value' => 'yes',
                'default' => 'yes',
            ]
        );
        $this->add_control(
            'ekobyte_sub_title',
            [
                'label' => esc_html__('Sub Title', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ekobyte Sub Title', 'ekobytecore'),
                'placeholder' => esc_html__('Type Sub Heading Text', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'ekobyte_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'ekobyte_title',
            [
                'label' => esc_html__('Title', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ekobyte Title Here', 'ekobytecore'),
                'placeholder' => esc_html__('Type Heading Text', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'ekobyte_title_color',
            [
                'label' => __( 'Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'ekobyte_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'ekobytecore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'ekobytecore'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'ekobytecore'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'ekobytecore'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'ekobytecore'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'ekobytecore'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'ekobytecore'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'ekobyte_align',
            [
                'label' => esc_html__('Alignment', 'ekobytecore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'text-left' => [
                        'title' => esc_html__('Left', 'ekobytecore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__('Center', 'ekobytecore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'text-right' => [
                        'title' => esc_html__('Right', 'ekobytecore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
            ]
        );
        $this->end_controls_section();



        /**
         * Review section
         */
        $this->start_controls_section(
            'review_list',
            [
                'label' => esc_html__( 'Review List', 'ekobytecore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();


        $repeater->add_control(
            'reviewer_image',
            [
                'label' => esc_html__( 'Reviewer Image', 'ekobytecore' ),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $repeater->add_control(
            'reviewer_name', [
                'label' => esc_html__( 'Reviewer Name', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Rasalina William' , 'ekobytecore' ),
                'label_block' => true,
            ]
        );        

        $repeater->add_control(
            'reviewer_designation', [
                'label' => esc_html__( 'Designation', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( '- CEO' , 'ekobytecore' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'reviewer_designation_color',
            [
                'label' => __( 'Designation Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .profile-text p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'review_heading', [
                'label' => esc_html__( 'Review Heading', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'Highly Recommended!' , 'ekobytecore' ),
                'label_block' => true,
            ]
        );        


        $repeater->add_control(
            'review_content',
            [
                'label' => esc_html__( 'Review Content', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'rows' => 10,
                'default' => 'Aklima The standard chunk of Lorem Ipsum used since the 1500s is reproduced below for those interested. Sections Bonorum et Malorum original.',
                'placeholder' => esc_html__( 'Type your review content here', 'ekobytecore' ),
            ]
        );

        $repeater->add_control(
            'review_content_color',
            [
                'label' => __( 'Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .swiper-slide .client-card .client-card-2 p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'reviews_list',
            [
                'label' => esc_html__( 'Review List', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' =>  $repeater->get_controls(),
                'default' => [
                    [
                        'reviewer_name' => esc_html__( 'Rasalina William', 'ekobytecore' ),
                        'reviewer_designation' => esc_html__( 'CEO', 'ekobytecore' ),
                        'review_content' => esc_html__( 'Put your trust in us &share in our people with a passion.We are motivated by the satisfaction H.Spond Asset Management is made up of a team of expert, committed and experienced for of clients financial markets. Our goal is to achieve continuous.', 'ekobytecore' ),
                    ],
                    [
                        'reviewer_name' => esc_html__( 'Rasalina William', 'ekobytecore' ),
                        'reviewer_designation' => esc_html__( 'MD', 'ekobytecore' ),
                        'review_content' => esc_html__( 'Put your trust in us &share in our people with a passion.We are motivated by the satisfaction H.Spond Asset Management is made up of a team of expert, committed and experienced for of clients financial markets. Our goal is to achieve continuous.', 'ekobytecore' ),
                    ],
                    [
                        'reviewer_name' => esc_html__( 'Rasalina William', 'ekobytecore' ),
                        'reviewer_designation' => esc_html__( 'Manager', 'ekobytecore' ),
                        'review_content' => esc_html__( 'Put your trust in us &share in our people with a passion.We are motivated by the satisfaction H.Spond Asset Management is made up of a team of expert, committed and experienced for of clients financial markets. Our goal is to achieve continuous.', 'ekobytecore' ),
                    ],

                ],
                'title_field' => '{{{ reviewer_name }}}',
            ]
        );
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail_size',
                'default' => 'thumbnail',
                'exclude' => ['custom'],
                'separator' => 'none',
            ]
        );

        $this->end_controls_section();
		

        /**
         * Style section
         */
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'ekobytecore' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_transform',
			[
				'label' => __( 'Text Transform', 'ekobytecore' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => __( 'None', 'ekobytecore' ),
					'uppercase' => __( 'UPPERCASE', 'ekobytecore' ),
					'lowercase' => __( 'lowercase', 'ekobytecore' ),
					'capitalize' => __( 'Capitalize', 'ekobytecore' ),
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget ouekobyteut on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

        <?php if ( $settings['ekobyte_design_style']  == 'layout-3' ): 
            $this->add_render_attribute('title_args', 'class', 'title');
        ?>
        
        <!-- Testimonial Area Start -->
        <div class="testimonial-slider-area style-3">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="te-section-title left-align-title">
                            <div class="te-section-content">
                                <div>
                                    <?php if ( !empty($settings['ekobyte_sub_title']) ) : ?>
                                        <span class="short-title only-divider"><?php echo ekobyte_kses( $settings['ekobyte_sub_title'] ); ?></span>
                                    <?php endif; ?>
                                </div>
                                <?php
                                    if ( !empty($settings['ekobyte_title' ]) ) :
                                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape( $settings['ekobyte_title_tag'] ),
                                            $this->get_render_attribute_string( 'title_args' ),
                                            ekobyte_kses( $settings['ekobyte_title' ] )
                                            );
                                    endif;
                                ?>
                            </div>
                            <div  class="te-section-desc">
                                <div class="te-slider-btn-wrapper">
                                    <a href="#" class="te-slider-nav te-slider-prev" id="testimonial_slider_prev">
                                        <i class="fa-solid fa-arrow-left"></i>
                                    </a>
                                    <a href="#" class="te-slider-nav te-slider-next" id="testimonial_slider_next">
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="te-testimonial-slider-wrapper" id="testimonial_one">
                            <?php foreach ($settings['reviews_list'] as $index => $item) :
                                if ( !empty($item['reviewer_image']['url']) ) {
                                    $ekobyte_reviewer_image = !empty($item['reviewer_image']['id']) ? wp_get_attachment_image_url( $item['reviewer_image']['id'], $settings['thumbnail_size_size']) : $item['reviewer_image']['url'];
                                    $ekobyte_reviewer_image_alt = get_post_meta($item["reviewer_image"]["id"], "_wp_attachment_image_alt", true);
                                }
                            ?>
                                <div>
                                    <div class="te-testimonial-card style-3">
                                        <div class="te-content-wrapper">
                                            <div class="content">
                                                <?php if ( !empty($item['review_heading']) ) : ?>
                                                    <h4 class="title"><?php echo ekobyte_kses($item['review_heading']); ?></h4>
                                                <?php endif; ?>
                                                <?php if ( !empty($item['review_content']) ) : ?>
                                                    <p><?php echo ekobyte_kses($item['review_content']); ?></p>
                                                <?php endif; ?>
                                            </div>
                                            <div class="te-user-meta">
                                                <div class="te-user-info">
                                                    <?php if ( !empty($ekobyte_reviewer_image) ) : ?> 
                                                        <div class="image">
                                                            <img src="<?php echo esc_url($ekobyte_reviewer_image); ?>" alt="<?php echo esc_url($ekobyte_reviewer_image_alt); ?>">
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="info">
                                                        <div class="rating">
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                            <i class="fa-solid fa-star"></i>
                                                        </div>
                                                        <?php if ( !empty($item['reviewer_name']) ) : ?>
                                                            <h2 class="name"><?php echo ekobyte_kses($item['reviewer_name']); ?>, 
                                                                <?php if ( !empty($item['reviewer_designation']) ) : ?>
                                                                    <span><?php echo ekobyte_kses($item['reviewer_designation']); ?></span>
                                                                <?php endif; ?>
                                                            </h2>
                                                        <?php endif; ?>                                   
                                                    </div>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa-solid fa-quote-right"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Testimonial Area End -->

		<?php elseif ( $settings['ekobyte_design_style']  == 'layout-2' ): 
            $this->add_render_attribute('title_args', 'class', 'title');
        ?>
    
        <!-- Testimonial Area Start -->
        <div class="testimonial-slider-area style-2">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="te-section-title justify-content-center text-center">
                            <div class="te-section-content">
                                <?php if ( !empty($settings['ekobyte_sub_title']) ) : ?>   
                                    <div>
                                        <span class="short-title"><?php echo ekobyte_kses( $settings['ekobyte_sub_title'] ); ?></span>
                                    </div>
                                <?php endif; ?>
                                <?php
                                    if ( !empty($settings['ekobyte_title']) ) :
                                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape( $settings['ekobyte_title_tag'] ),
                                            $this->get_render_attribute_string( 'title_args' ),
                                            ekobyte_kses( $settings['ekobyte_title' ] )
                                            );
                                    endif;
                                ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="te-testimonial-slider-wrapper" id="testimonial_two">
                <?php foreach ($settings['reviews_list'] as $index => $item) :
                    if ( !empty($item['reviewer_image']['url']) ) {
                        $ekobyte_reviewer_image = !empty($item['reviewer_image']['id']) ? wp_get_attachment_image_url( $item['reviewer_image']['id'], $settings['thumbnail_size_size']) : $item['reviewer_image']['url'];
                        $ekobyte_reviewer_image_alt = get_post_meta($item["reviewer_image"]["id"], "_wp_attachment_image_alt", true);
                    }
                ?>
                    <div class="te-slick-item">
                        <div class="te-testimonial-card-two">
                            <div class="te-content-wrapper">
                                <div class="te-user-meta">
                                    <div class="te-user-info">
                                        <div class="icon">
                                            <i class="fa-solid fa-quote-right"></i>
                                        </div>
                                        <?php if ( !empty($item['reviewer_name']) ) : ?>
                                            <h2 class="name"><?php echo ekobyte_kses($item['reviewer_name']); ?></h2>
                                        <?php endif; ?>
                                        <?php if ( !empty($item['reviewer_designation']) ) : ?>
                                            <span class="designation"><?php echo ekobyte_kses($item['reviewer_designation']); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <?php if ( !empty($ekobyte_reviewer_image) ) : ?>
                                        <div class="image">   
                                            <img src="<?php echo esc_url($ekobyte_reviewer_image); ?>" alt="<?php echo esc_url($ekobyte_reviewer_image_alt); ?>">
                                        </div>
                                    <?php endif; ?>
                                </div>
                                <div class="content">
                                    <?php if ( !empty($item['review_content']) ) : ?>
                                        <p><?php echo ekobyte_kses($item['review_content']); ?></p>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                <?php endforeach; ?>
            </div>
        </div>
        <!-- Testimonial Area End -->
        <div class="testimonial-bg-area"></div>

		<?php else: 
			$this->add_render_attribute('title_args', 'class', 'title');
        ?>

        <!-- Testimonial Area Start -->
        <div class="testimonial-slider-area style-1">
            <div class="container">
                <div class="row">
                    <div class="col-12">
                        <div class="te-section-title left-align-title">
                            <div class="te-section-content">
                                <?php if ( !empty($settings['ekobyte_sub_title']) ) : ?>
                                    <div>
                                        <span class="short-title only-divider"><?php echo ekobyte_kses( $settings['ekobyte_sub_title'] ); ?></span>
                                    </div>
                                <?php endif; ?>
                                <?php
                                    if ( !empty($settings['ekobyte_title' ]) ) :
                                        printf( '<%1$s %2$s>%3$s</%1$s>',
                                            tag_escape( $settings['ekobyte_title_tag'] ),
                                            $this->get_render_attribute_string( 'title_args' ),
                                            ekobyte_kses( $settings['ekobyte_title' ] )
                                            );
                                    endif;
                                ?>
                            </div>
                            <div  class="te-section-desc">
                                <div class="te-slider-btn-wrapper">
                                    <a href="#" class="te-slider-nav te-slider-prev" id="testimonial_slider_prev">
                                        <i class="fa-solid fa-arrow-left"></i>
                                    </a>
                                    <a href="#" class="te-slider-nav te-slider-next" id="testimonial_slider_next">
                                        <i class="fa-solid fa-arrow-right"></i>
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div class="te-testimonial-slider-wrapper" id="testimonial_one">
                            <?php foreach ($settings['reviews_list'] as $index => $item) :
                                if ( !empty($item['reviewer_image']['url']) ) {
                                    $ekobyte_reviewer_image = !empty($item['reviewer_image']['id']) ? wp_get_attachment_image_url( $item['reviewer_image']['id'], $settings['thumbnail_size_size']) : $item['reviewer_image']['url'];
                                    $ekobyte_reviewer_image_alt = get_post_meta($item["reviewer_image"]["id"], "_wp_attachment_image_alt", true);
                                }
                            ?>
                                <div>
                                    <div class="te-testimonial-card">
                                        <div class="te-content-wrapper">
                                            <div class="content">
                                                <?php if ( !empty($item['review_content']) ) : ?>
                                                    <p><?php echo ekobyte_kses($item['review_content']); ?></p>
                                                <?php endif; ?>
                                            </div>
                                            <div class="te-user-meta">
                                                <div class="te-user-info">
                                                    <?php if ( !empty($ekobyte_reviewer_image) ) : ?> 
                                                        <div class="image">
                                                            <img src="<?php echo esc_url($ekobyte_reviewer_image); ?>" alt="<?php echo esc_url($ekobyte_reviewer_image_alt); ?>">
                                                        </div>
                                                    <?php endif; ?>
                                                    <div class="info">
                                                        <?php if ( !empty($item['reviewer_name']) ) : ?>
                                                            <h2 class="name"><?php echo ekobyte_kses($item['reviewer_name']); ?></h2>
                                                        <?php endif; ?>
                                                        <?php if ( !empty($item['reviewer_designation']) ) : ?>
                                                            <span class="designation"><?php echo ekobyte_kses($item['reviewer_designation']); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                                <div class="icon">
                                                    <i class="fa-solid fa-quote-right"></i>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            <?php endforeach; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- Testimonial Area End -->

        <?php endif; ?>

        <?php 
	}
}

$widgets_manager->register( new Ekobyte_Testimonial() );