<?php
namespace EkobyteCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Ekobyte Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Ekobyte_Contact_Form extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'contactform';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Contact Form', 'ekobytecore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'ekobyte-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'ekobytecore' ];
	}


    public function get_ekobyte_contact_form(){
        if ( ! class_exists( 'WPCF7' ) ) {
            return;
        }
        $ekobyte_cfa         = array();
        $ekobyte_cf_args     = array( 'posts_per_page' => -1, 'post_type'=> 'wpcf7_contact_form' );
        $ekobyte_forms       = get_posts( $ekobyte_cf_args );
        $ekobyte_cfa         = ['0' => esc_html__( 'Select Form', 'ekobytecore' ) ];
        if( $ekobyte_forms ){
            foreach ( $ekobyte_forms as $ekobyte_form ){
                $ekobyte_cfa[$ekobyte_form->ID] = $ekobyte_form->post_title;
            }
        }else{
            $ekobyte_cfa[ esc_html__( 'No contact form found', 'ekobytecore' ) ] = 0;
        }
        return $ekobyte_cfa;
	}
	
		/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */

    protected static function get_profile_names()
    {
        return [
            '500px' => esc_html__('500px', 'ekobytecore'),
            'apple' => esc_html__('Apple', 'ekobytecore'),
            'behance' => esc_html__('Behance', 'ekobytecore'),
            'bitbucket' => esc_html__('BitBucket', 'ekobytecore'),
            'codepen' => esc_html__('CodePen', 'ekobytecore'),
            'delicious' => esc_html__('Delicious', 'ekobytecore'),
            'deviantart' => esc_html__('DeviantArt', 'ekobytecore'),
            'digg' => esc_html__('Digg', 'ekobytecore'),
            'dribbble' => esc_html__('Dribbble', 'ekobytecore'),
            'email' => esc_html__('Email', 'ekobytecore'),
            'facebook' => esc_html__('Facebook', 'ekobytecore'),
            'flickr' => esc_html__('Flicker', 'ekobytecore'),
            'foursquare' => esc_html__('FourSquare', 'ekobytecore'),
            'github' => esc_html__('Github', 'ekobytecore'),
            'houzz' => esc_html__('Houzz', 'ekobytecore'),
            'instagram' => esc_html__('Instagram', 'ekobytecore'),
            'jsfiddle' => esc_html__('JS Fiddle', 'ekobytecore'),
            'linkedin' => esc_html__('LinkedIn', 'ekobytecore'),
            'medium' => esc_html__('Medium', 'ekobytecore'),
            'pinterest' => esc_html__('Pinterest', 'ekobytecore'),
            'product-hunt' => esc_html__('Product Hunt', 'ekobytecore'),
            'reddit' => esc_html__('Reddit', 'ekobytecore'),
            'slideshare' => esc_html__('Slide Share', 'ekobytecore'),
            'snapchat' => esc_html__('Snapchat', 'ekobytecore'),
            'soundcloud' => esc_html__('SoundCloud', 'ekobytecore'),
            'spotify' => esc_html__('Spotify', 'ekobytecore'),
            'stack-overflow' => esc_html__('StackOverflow', 'ekobytecore'),
            'tripadvisor' => esc_html__('TripAdvisor', 'ekobytecore'),
            'tumblr' => esc_html__('Tumblr', 'ekobytecore'),
            'twitch' => esc_html__('Twitch', 'ekobytecore'),
            'twitter' => esc_html__('Twitter', 'ekobytecore'),
            'vimeo' => esc_html__('Vimeo', 'ekobytecore'),
            'vk' => esc_html__('VK', 'ekobytecore'),
            'website' => esc_html__('Website', 'ekobytecore'),
            'whatsapp' => esc_html__('WhatsApp', 'ekobytecore'),
            'wordpress' => esc_html__('WordPress', 'ekobytecore'),
            'xing' => esc_html__('Xing', 'ekobytecore'),
            'yelp' => esc_html__('Yelp', 'ekobytecore'),
            'youtube' => esc_html__('YouTube', 'ekobytecore'),
        ];
    }


	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

		/**
		 * Form
		 */

        $this->start_controls_section(
            'ekobytecore_contact',
            [
                'label' => esc_html__('Contact Form', 'ekobytecore'),
            ]
		);
		
		$this->add_control(
			'ekobyte_form_title',
			[
				'label' => esc_html__('Form Title', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Get A Quote', 'ekobytecore'),
				'placeholder' => esc_html__('Type form title', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
            'ekobyte_form_title_color',
            [
                'label' => __( 'Form Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
		);

        $this->add_control(
            'ekobytecore_select_contact_form',
            [
                'label'   => esc_html__( 'Select Form', 'ekobytecore' ),
                'type'    => Controls_Manager::SELECT,
                'default' => '0',
                'options' => $this->get_ekobyte_contact_form(),
            ]
        );

		$this->end_controls_section();


		/**
		 * Information
		 */
		$this->start_controls_section(
			'_information',
			[
				'label' => esc_html__( 'Information', 'ekobytecore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);
		
		$this->add_control(
			'ekobyte_section_title_show',
			[
				'label' => esc_html__( 'Section Title & Content', 'ekobytecore' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => esc_html__( 'Show', 'ekobytecore' ),
				'label_off' => esc_html__( 'Hide', 'ekobytecore' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'ekobyte_title',
			[
				'label' => esc_html__('Title', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Ekobyte Title Here', 'ekobytecore'),
				'placeholder' => esc_html__('Type Heading Text', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
            'ekobyte_title_color',
            [
                'label' => __( 'Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
			'ekobyte_description',
			[
				'label' => esc_html__('Description', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXTAREA,
				'default' => esc_html__('Ekobyte section description here', 'ekobytecore'),
				'placeholder' => esc_html__('Type section description here', 'ekobytecore'),
			]
		);

		$this->add_control(
            'ekobyte_description_color',
            [
                'label' => __( 'Description Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title p' => 'color: {{VALUE}}',
                ],
            ]
        );

		$this->add_control(
			'ekobyte_title_tag',
			[
				'label' => esc_html__('Title HTML Tag', 'ekobytecore'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'h1' => [
						'title' => esc_html__('H1', 'ekobytecore'),
						'icon' => 'eicon-editor-h1'
					],
					'h2' => [
						'title' => esc_html__('H2', 'ekobytecore'),
						'icon' => 'eicon-editor-h2'
					],
					'h3' => [
						'title' => esc_html__('H3', 'ekobytecore'),
						'icon' => 'eicon-editor-h3'
					],
					'h4' => [
						'title' => esc_html__('H4', 'ekobytecore'),
						'icon' => 'eicon-editor-h4'
					],
					'h5' => [
						'title' => esc_html__('H5', 'ekobytecore'),
						'icon' => 'eicon-editor-h5'
					],
					'h6' => [
						'title' => esc_html__('H6', 'ekobytecore'),
						'icon' => 'eicon-editor-h6'
					]
				],
				'default' => 'h2',
				'toggle' => false,
			]
		);

		$this->add_responsive_control(
			'ekobyte_align',
			[
				'label' => esc_html__('Alignment', 'ekobytecore'),
				'type' => Controls_Manager::CHOOSE,
				'options' => [
					'left' => [
						'title' => esc_html__('Left', 'ekobytecore'),
						'icon' => 'eicon-text-align-left',
					],
					'center' => [
						'title' => esc_html__('Center', 'ekobytecore'),
						'icon' => 'eicon-text-align-center',
					],
					'right' => [
						'title' => esc_html__('Right', 'ekobytecore'),
						'icon' => 'eicon-text-align-right',
					],
				],
				'default' => 'left',
				'toggle' => false,
				'selectors' => [
					'{{WRAPPER}}' => 'text-align: {{VALUE}};'
				]
			]
		);

		// location
		$this->add_control(
			'ekobyte_single_icon_type_location',
			[
				'label' => esc_html__('Select Icon Type for Location', 'ekobytecore'),
				'type' => \Elementor\Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image' => esc_html__('Image', 'ekobytecore'),
					'icon' => esc_html__('Icon', 'ekobytecore'),
				],
			]
		);

		$this->add_control(
			'ekobyte_icon_image_location',
			[
				'label' => esc_html__('Upload Icon Image for Location', 'ekobytecore'),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'ekobyte_single_icon_type_location' => 'image'
				]

			]
		);

		if (ekobyte_is_elementor_version('<', '2.6.0')) {
			$this->add_control(
				'icon',
				[
					'show_label' => false,
					'type' => Controls_Manager::ICON,
					'label_block' => true,
					'default' => 'fa fa-star',
					'condition' => [
						'ekobyte_single_icon_type_location' => 'icon'
					]
				]
			);
		} else {
			$this->add_control(
				'selected_icon3',
				[
					'show_label' => false,
					'type' => Controls_Manager::ICONS,
					'fa4compatibility' => 'icon',
					'label_block' => true,
					'default' => [
						'value' => 'far fa-star',
						'library' => 'regular',
					],
					'condition' => [
						'ekobyte_single_icon_type_location' => 'icon'
					]
				]
			);
		}

		$this->add_control(
			'ekobyte_left_info_location_heading',
			[
				'label' => esc_html__('Location Heading', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Location', 'ekobytecore'),
				'placeholder' => esc_html__('Type location heading', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'ekobyte_left_info_location_heading_color',
			[
				'label' => __( 'Location Heading Color', 'ekobytecore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-us .contact-left .content h4' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'ekobyte_left_info_location',
			[
				'label' => esc_html__('Location', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('99 chicago,America', 'ekobytecore'),
				'placeholder' => esc_html__('Type your location', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
			'ekobyte_left_info_location_color',
			[
				'label' => __( 'Location Color', 'ekobytecore' ),
				'type' => Controls_Manager::COLOR,
				'selectors' => [
					'{{WRAPPER}} .contact-us .contact-left .content p' => 'color: {{VALUE}}',
				],
			]
		);
		
		$this->add_control(
			'ekobyte_left_info_location_map',
			[
				'label' => esc_html__('Location Map', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('https://goo.gl/maps/qzqY2PAcQwUz1BYN9', 'ekobytecore'),
				'placeholder' => esc_html__('Type your location map address', 'ekobytecore'),
				'label_block' => true,
			]
		);
		
        // phone
		$this->add_control(
            'ekobyte_single_icon_type_phone',
            [
                'label' => esc_html__('Select Icon Type for Phone', 'ekobytecore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'ekobytecore'),
                    'icon' => esc_html__('Icon', 'ekobytecore'),
                ],
            ]
        );

        $this->add_control(
            'ekobyte_icon_image_phone',
            [
                'label' => esc_html__('Upload Icon Image for Phone', 'ekobytecore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'ekobyte_single_icon_type_phone' => 'image'
                ]

            ]
        );

        if (ekobyte_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'ekobyte_single_icon_type_phone' => 'icon'
                    ]
                ]
            );
        } else {
            $this->add_control(
                'selected_icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'far fa-star',
                        'library' => 'regular',
                    ],
                    'condition' => [
                        'ekobyte_single_icon_type_phone' => 'icon'
                    ]
                ]
            );
        }
		$this->add_control(
			'ekobyte_left_info_phone_heading',
			[
				'label' => esc_html__('Phone Number Heading', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Phone Number', 'ekobytecore'),
				'placeholder' => esc_html__('Type phone number heading', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
            'ekobyte_left_info_phone_heading_color',
            [
                'label' => __( 'Phone Number Heading Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us .contact-left .content h4' => 'color: {{VALUE}}',
                ],
            ]
		);
		
		$this->add_control(
			'ekobyte_left_info_phone_number',
			[
				'label' => esc_html__('Phone Number', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('111-123123', 'ekobytecore'),
				'placeholder' => esc_html__('Type your phone number', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
            'ekobyte_left_info_phone_number_color',
            [
                'label' => __( 'Phone Number Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us .contact-left .content p' => 'color: {{VALUE}}',
                ],
            ]
        );
		
		// email
		$this->add_control(
            'ekobyte_single_icon_type_email',
            [
                'label' => esc_html__('Select Icon Type for Email', 'ekobytecore'),
                'type' => \Elementor\Controls_Manager::SELECT,
                'default' => 'image',
                'options' => [
                    'image' => esc_html__('Image', 'ekobytecore'),
                    'icon' => esc_html__('Icon', 'ekobytecore'),
                ],
            ]
        );

        $this->add_control(
            'ekobyte_icon_image_email',
            [
                'label' => esc_html__('Upload Icon Image for Email', 'ekobytecore'),
                'type' => Controls_Manager::MEDIA,
                'default' => [
                    'url' => Utils::get_placeholder_image_src(),
                ],
                'condition' => [
                    'ekobyte_single_icon_type_email' => 'image'
                ]

            ]
        );

        if (ekobyte_is_elementor_version('<', '2.6.0')) {
            $this->add_control(
                'icon',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICON,
                    'label_block' => true,
                    'default' => 'fa fa-star',
                    'condition' => [
                        'ekobyte_single_icon_type_email' => 'icon'
                    ]
                ]
            );
        } else {
            $this->add_control(
                'selected_icon2',
                [
                    'show_label' => false,
                    'type' => Controls_Manager::ICONS,
                    'fa4compatibility' => 'icon',
                    'label_block' => true,
                    'default' => [
                        'value' => 'far fa-star',
                        'library' => 'regular',
                    ],
                    'condition' => [
                        'ekobyte_single_icon_type_email' => 'icon'
                    ]
                ]
            );
        }
        
		$this->add_control(
			'ekobyte_left_info_email_heading',
			[
				'label' => esc_html__('Email Heading', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('Email', 'ekobytecore'),
				'placeholder' => esc_html__('Type email heading', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
            'ekobyte_left_info_email_heading_color',
            [
                'label' => __( 'Email Heading Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us .contact-left .content h4' => 'color: {{VALUE}}',
                ],
            ]
		);
		
		$this->add_control(
			'ekobyte_left_info_email',
			[
				'label' => esc_html__('Email', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('your@email.com', 'ekobytecore'),
				'placeholder' => esc_html__('Type your email', 'ekobytecore'),
				'label_block' => true,
			]
		);

		$this->add_control(
            'ekobyte_left_info_email_color',
            [
                'label' => __( 'Email Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .contact-us .contact-left .content p' => 'color: {{VALUE}}',
                ],
            ]
		);
		
		$this->end_controls_section();

		/**
         * Social profile section
         */
        $this->start_controls_section(
            '_section_social',
            [
                'label' => esc_html__('Social Profiles', 'ekobytecore'),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'name',
            [
                'label' => esc_html__('Profile Name', 'ekobytecore'),
                'type' => Controls_Manager::SELECT2,
                'label_block' => true,
                'select2options' => [
                    'allowClear' => false,
                ],
                'options' => self::get_profile_names()
            ]
        );

        $repeater->add_control(
            'link', [
                'label' => esc_html__('Profile Link', 'ekobytecore'),
                'placeholder' => esc_html__('Add your profile link', 'ekobytecore'),
                'type' => Controls_Manager::URL,
                'label_block' => true,
                'autocomplete' => false,
                'show_external' => false,
                'condition' => [
                    'name!' => 'email'
                ],
                'dynamic' => [
                    'active' => true,
                ]
            ]
        );
        $this->add_control(
            'profiles',
            [
                'show_label' => false,
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'title_field' => '<# print(name.slice(0,1).toUpperCase() + name.slice(1)) #>',
                'default' => [
                    [
                        'link' => ['url' => 'https://facebook.com/'],
                        'name' => 'facebook'
                    ],
                    [
                        'link' => ['url' => 'https://linkedin.com/'],
                        'name' => 'linkedin'
                    ],
                    [
                        'link' => ['url' => 'https://twitter.com/'],
                        'name' => 'twitter'
                    ],
                    [
                        'link' => ['url' => 'https://instagram.com/'],
                        'name' => 'instagram'
                    ],
                    [
                        'link' => ['url' => 'https://youtube.com/'],
                        'name' => 'youtube'
                    ]
                ],
            ]
        );

        $this->add_control(
            'show_profiles',
            [
                'label' => esc_html__('Show Profiles', 'ekobytecore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Show', 'ekobytecore'),
                'label_off' => esc_html__('Hide', 'ekobytecore'),
                'return_value' => 'yes',
                'default' => 'yes',
                'separator' => 'before',
                'style_transfer' => true,
            ]
        );

        $this->end_controls_section();
		

		/**
		 * Map
		 */
		$this->start_controls_section(
			'_ekobyte_map',
			[
				'label' => esc_html__( 'Google Map', 'ekobytecore' ),
				'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'ekobyte_google_map_src',
			[
				'label' => esc_html__('Google Map', 'ekobytecore'),
				'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
				'type' => Controls_Manager::TEXT,
				'default' => esc_html__('https://www.google.com/maps/embed?pb=!1m18!1m12!1m3!1d423284.04409246973!2d-118.74137159485794!3d34.020608470699536!2m3!1f0!2f0!3f0!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x80c2c75ddc27da13%3A0xe22fdf6f254608f4!2sLos%20Angeles%2C%20CA%2C%20USA!5e0!3m2!1sen!2sbd!4v1692992084415!5m2!1sen!2sbd" allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade', 'ekobytecore'),
				'placeholder' => esc_html__('Type your google map iframe src', 'ekobytecore'),
				'label_block' => true,
			]
		);
		
		$this->end_controls_section();


		/**
		 * Style section
		 */
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'ekobytecore' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_transform',
			[
				'label' => __( 'Text Transform', 'ekobytecore' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => __( 'None', 'ekobytecore' ),
					'uppercase' => __( 'UPPERCASE', 'ekobytecore' ),
					'lowercase' => __( 'lowercase', 'ekobytecore' ),
					'capitalize' => __( 'Capitalize', 'ekobytecore' ),
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget ouekobyteut on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_render_attribute('title_args', 'class', 'title');

		if ( !empty($settings['ekobyte_google_map_src']) ) {
            $ekobyte_google_map_src = !empty($settings['ekobyte_google_map_src']) ? $settings['ekobyte_google_map_src'] : 'Iframe src is invalid';
		}
		?>
		
		<!-- Contact Form Section Start -->
		<div class="contact-form-area">
			<div class="container">
				<div class="row">
					<div class="col-lg-8 order-2 order-lg-1">
						<!-- Comment Form Start -->
						<div class="te-comment-respond mt-0">
							<?php
								if ( !empty($settings['ekobyte_form_title' ]) ) :
									printf( '<%1$s %2$s>%3$s</%1$s>',
										tag_escape( $settings['ekobyte_title_tag'] ),
										$this->get_render_attribute_string( 'title_args' ),
										ekobyte_kses( $settings['ekobyte_form_title' ] )
										);
								endif;
							?>
							<?php if( !empty($settings['ekobytecore_select_contact_form']) ) : ?> 
								<div class="te-comment-form"> 
									<?php echo do_shortcode( '[contact-form-7  id="'.$settings['ekobytecore_select_contact_form'].'"]' ); ?> 
								</div> 
							<?php else : ?>
									<?php echo '<div class="alert alert-info"><p class="m-0">' . __('Please Select contact form.', 'ekobytecore' ). '</p></div>'; ?>
							<?php endif; ?>

						</div>
						<!-- Comment Form End -->
					</div>
					<div class="col-lg-4 order-1 order-lg-2">
						<!-- Contact Info Section Start !-->
						<div class="te-contact-info-wrapper">
							<div class="te-title-wrapper">
								<?php
								if ( !empty($settings['ekobyte_title' ]) ) :
									printf( '<%1$s %2$s>%3$s</%1$s>',
										tag_escape( $settings['ekobyte_title_tag'] ),
										$this->get_render_attribute_string( 'title_args' ),
										ekobyte_kses( $settings['ekobyte_title' ] )
										);
								endif;
							?>
								<?php if ( !empty($settings['ekobyte_description']) ) : ?>
									<p><?php echo ekobyte_kses( $settings['ekobyte_description'] ); ?></p>
								<?php endif; ?>
							</div>
							<div class="te-contact-info">
								<div class="te-icon-card style-2">
									<div class="icon">
										<?php if($settings['ekobyte_single_icon_type_location'] !== 'image') : ?>
											<?php if (!empty($settings['icon']) || !empty($settings['selected_icon3']['value'])) : ?>
												<?php ekobyte_render_icon($settings, 'icon', 'selected_icon3'); ?>
											<?php endif; ?>   
										<?php else : ?>                                
											<?php if (!empty($settings['ekobyte_icon_image']['url'])): ?>  
												<img src="<?php echo $settings['ekobyte_icon_image']['url']; ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($settings['ekobyte_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
											<?php endif; ?> 
										<?php endif; ?> 
									</div>
									<div class="content">
										<?php if ( !empty($settings['ekobyte_left_info_location_heading']) ) : ?>    
											<h3 class="title"><?php echo ekobyte_kses( $settings['ekobyte_left_info_location_heading'] ); ?></h3>
										<?php endif; ?>
										<?php if ( !empty($settings['ekobyte_left_info_location']) ) : ?>
											<span class="desc"><a href="<?php echo ekobyte_kses( $settings['ekobyte_left_info_location_map'] ); ?>"><?php echo ekobyte_kses( $settings['ekobyte_left_info_location'] ); ?></a></span>
										<?php endif; ?>
									</div>
								</div>
								<div class="te-icon-card style-2">
									<div class="icon">
										<?php if($settings['ekobyte_single_icon_type_phone'] !== 'image') : ?>
											<?php if (!empty($settings['icon']) || !empty($settings['selected_icon']['value'])) : ?>
												<?php ekobyte_render_icon($settings, 'icon', 'selected_icon'); ?>
											<?php endif; ?>   
										<?php else : ?>                                
											<?php if (!empty($settings['ekobyte_icon_image']['url'])): ?>  
												<img src="<?php echo $settings['ekobyte_icon_image']['url']; ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($settings['ekobyte_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
											<?php endif; ?> 
										<?php endif; ?> 
									</div>
									<div class="content">
										<?php if ( !empty($settings['ekobyte_left_info_phone_heading']) ) : ?>    
											<h3 class="title"><?php echo ekobyte_kses( $settings['ekobyte_left_info_phone_heading'] ); ?></h3>
										<?php endif; ?>
										<?php if ( !empty($settings['ekobyte_left_info_phone_number']) ) : ?>
											<a href="tel:<?php echo esc_attr(str_replace(' ', '-', $settings['ekobyte_left_info_phone_number'])); ?>" class="desc"><?php echo ekobyte_kses( $settings['ekobyte_left_info_phone_number'] ); ?></a>
										<?php endif; ?>
									</div>
								</div>

								<div class="te-icon-card style-2">
									<div class="icon">
										<?php if($settings['ekobyte_single_icon_type_email'] !== 'image') : ?>
											<?php if (!empty($settings['icon']) || !empty($settings['selected_icon2']['value'])) : ?>
												<?php ekobyte_render_icon($settings, 'icon', 'selected_icon2'); ?>
											<?php endif; ?>   
										<?php else : ?>                                
											<?php if (!empty($settings['ekobyte_icon_image']['url'])): ?>  
												<img src="<?php echo $settings['ekobyte_icon_image']['url']; ?>" alt="<?php echo get_post_meta(attachment_url_to_postid($settings['ekobyte_icon_image']['url']), '_wp_attachment_image_alt', true); ?>">
											<?php endif; ?> 
										<?php endif; ?>
									</div>
									<div class="content">
										<?php if ( !empty($settings['ekobyte_left_info_email_heading']) ) : ?>    
											<h3 class="title"><?php echo ekobyte_kses( $settings['ekobyte_left_info_email_heading'] ); ?></h3>
										<?php endif; ?>
										<?php if ( !empty($settings['ekobyte_left_info_email']) ) : ?>
											<a href="mailto:<?php echo ekobyte_kses( $settings['ekobyte_left_info_email'] ); ?>" class="desc"><?php echo ekobyte_kses( $settings['ekobyte_left_info_email'] ); ?></a>
										<?php endif; ?>
									</div>
								</div>
							</div>
							<?php if ($settings['show_profiles'] && is_array($settings['profiles'])) : ?>
								<div class="te-social-profile-link">
									<?php
									foreach ($settings['profiles'] as $profile) :
										$icon = esc_attr($profile['name']);
										$url = esc_url($profile['link']['url']);
										?>
										<a href="<?php echo $url;?>"><i class="fa-brands fa-<?php echo $icon;?>"></i></a>
									<?php
									endforeach; ?>
								</div>
							<?php endif; ?>
						</div>
						<!-- Contact Info Section End -->
					</div>
				</div>
			</div>
		</div>
		<!-- Contact Form Section End -->

		<!-- Map start -->
		<div class="contact-map-area">
			<div class="te-map-widget">
				<iframe src="<?php echo esc_url($ekobyte_google_map_src);?>"></iframe>
			</div>
		</div>
		<!-- Map end -->

        <?php 
	}
}

$widgets_manager->register( new Ekobyte_Contact_Form() );