<?php
namespace EkobyteCore\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;
use \Elementor\Group_Control_Background;
use \Elementor\Group_Control_Image_Size;
use \Elementor\Repeater;
use \Elementor\Utils;
use \Elementor\Control_Media;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Ekobyte Core
 *
 * Elementor widget for hello world.
 *
 * @since 1.0.0
 */
class Ekobyte_Faq extends Widget_Base {

	/**
	 * Retrieve the widget name.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget name.
	 */
	public function get_name() {
		return 'ekobyte-faq';
	}

	/**
	 * Retrieve the widget title.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget title.
	 */
	public function get_title() {
		return __( 'Ekobyte FAQ', 'ekobytecore' );
	}

	/**
	 * Retrieve the widget icon.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return string Widget icon.
	 */
	public function get_icon() {
		return 'ekobyte-icon';
	}

	/**
	 * Retrieve the list of categories the widget belongs to.
	 *
	 * Used to determine where to display the widget in the editor.
	 *
	 * Note that currently Elementor supports only one category.
	 * When multiple categories passed, Elementor uses the first one.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget categories.
	 */
	public function get_categories() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Retrieve the list of scripts the widget depended on.
	 *
	 * Used to set scripts dependencies required to run the widget.
	 *
	 * @since 1.0.0
	 *
	 * @access public
	 *
	 * @return array Widget scripts dependencies.
	 */
	public function get_script_depends() {
		return [ 'ekobytecore' ];
	}

	/**
	 * Register the widget controls.
	 *
	 * Adds different input fields to allow the user to change and customize the widget settings.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function register_controls() {

        /**
         * Layout section
         */
        $this->start_controls_section(
            'ekobyte_layout',
            [
                'label' => esc_html__('Design Layout', 'ekobytecore'),
            ]
        );
        $this->add_control(
            'ekobyte_design_style',
            [
                'label' => esc_html__('Select Layout', 'ekobytecore'),
                'type' => Controls_Manager::SELECT,
                'options' => [
                    'layout-1' => esc_html__('Layout 1', 'ekobytecore'),
                ],
                'default' => 'layout-1',
            ]
        );

        $this->end_controls_section();

        /**
         * Title and content section
         */
        $this->start_controls_section(
            'ekobyte_section_title',
            [
                'label' => esc_html__('Title & Content', 'ekobytecore'),
            ]
        );


        $this->add_control(
            'ekobyte_sub_title',
            [
                'label' => esc_html__('Sub Title', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'basic' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ekobyte Sub Title', 'ekobytecore'),
                'placeholder' => esc_html__('Type Sub Title Text', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'ekobyte_sub_title_color',
            [
                'label' => __( 'Sub Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h6' => 'color: {{VALUE}}',
                ],
            ]
        );
        
        $this->add_control(
            'ekobyte_title',
            [
                'label' => esc_html__('Title', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Ekobyte Title Here', 'ekobytecore'),
                'placeholder' => esc_html__('Type Title Text', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'ekobyte_title_color',
            [
                'label' => __( 'Title Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .section-title h2' => 'color: {{VALUE}}',
                ],
            ]
        );
 
        $this->add_control(
            'ekobyte_title_tag',
            [
                'label' => esc_html__('Title HTML Tag', 'ekobytecore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'h1' => [
                        'title' => esc_html__('H1', 'ekobytecore'),
                        'icon' => 'eicon-editor-h1'
                    ],
                    'h2' => [
                        'title' => esc_html__('H2', 'ekobytecore'),
                        'icon' => 'eicon-editor-h2'
                    ],
                    'h3' => [
                        'title' => esc_html__('H3', 'ekobytecore'),
                        'icon' => 'eicon-editor-h3'
                    ],
                    'h4' => [
                        'title' => esc_html__('H4', 'ekobytecore'),
                        'icon' => 'eicon-editor-h4'
                    ],
                    'h5' => [
                        'title' => esc_html__('H5', 'ekobytecore'),
                        'icon' => 'eicon-editor-h5'
                    ],
                    'h6' => [
                        'title' => esc_html__('H6', 'ekobytecore'),
                        'icon' => 'eicon-editor-h6'
                    ]
                ],
                'default' => 'h2',
                'toggle' => false,
            ]
        );

        $this->add_responsive_control(
            'ekobyte_align',
            [
                'label' => esc_html__('Alignment', 'ekobytecore'),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'text-left' => [
                        'title' => esc_html__('Left', 'ekobytecore'),
                        'icon' => 'eicon-text-align-left',
                    ],
                    'text-center' => [
                        'title' => esc_html__('Center', 'ekobytecore'),
                        'icon' => 'eicon-text-align-center',
                    ],
                    'text-right' => [
                        'title' => esc_html__('Right', 'ekobytecore'),
                        'icon' => 'eicon-text-align-right',
                    ],
                ],
                'default' => 'left',
                'toggle' => false,
            ]
        );
        $this->end_controls_section();


        // FAQ Accordin
		$this->start_controls_section(
            '_accordion',
            [
                'label' => esc_html__( 'Accordion', 'ekobytecore' ),
                'tab' => \Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new \Elementor\Repeater();

        $repeater->add_control(
            'accordion_title', [
                'label' => esc_html__( 'Accordion Item', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'This is accordion item title' , 'ekobytecore' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'accordion_title_color',
            [
                'label' => __( 'Accordion Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} #commonFaqAccordion button' => 'color: {{VALUE}}',
                ],
            ]
        );

        $repeater->add_control(
            'accordion_description',
            [
                'label' => esc_html__('Description', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => \Elementor\Controls_Manager::TEXTAREA,
                'default' => 'Facilis fugiat hic ipsam iusto laudantium libero maiores minima molestiae mollitia repellat rerum sunt ullam voluptates? Perferendis, suscipit.',
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'accordion_description_color',
            [
                'label' => __( 'Description Color', 'ekobytecore' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    '{{WRAPPER}} .faq-content-body p' => 'color: {{VALUE}}',
                ],
            ]
        );

        $this->add_control(
            'accordions',
            [
                'label' => esc_html__( 'Repeater Accordion', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
                'default' => [
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #1', 'ekobytecore' ),
                    ],
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #2', 'ekobytecore' ),
                    ],
                    [
                        'accordion_title' => esc_html__( 'This is accordion item title #3', 'ekobytecore' ),
                    ]
                ],
                'title_field' => '{{{ accordion_title }}}',
            ]
        );

        $this->add_control(
            'space_accordion_item',
            [
                'label' => esc_html__( 'Accordion space gap', 'ekobytecore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .rn-card + .rn-card' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
            ]
        );

        $this->end_controls_section();



        /**
         * Image and counter section
         */
		$this->start_controls_section(
            '_ekobyte_image',
            [
                'label' => esc_html__('Image & Counter', 'ekobytecore'),
            ]
        );
       
        $this->add_control(
            'ekobyte_faq_image',
            [
                'label' => esc_html__( 'FAQ Image', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_control(
            'ekobyte_border_shape_image',
            [
                'label' => esc_html__( 'Border Shape Image', 'ekobytecore' ),
                'type' => \Elementor\Controls_Manager::MEDIA,
                'default' => [
                    'url' => \Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );
    
        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'ekobyte_image_size',
                'default' => 'full',
                'exclude' => [
                    'custom'
                ]
            ]
        );
        $this->add_control(
            'ekobyte_image_overlap',
            [
                'label' => esc_html__('Image overlap to top?', 'ekobytecore'),
                'type' => Controls_Manager::SWITCHER,
                'label_on' => esc_html__('Yes', 'ekobytecore'),
                'label_off' => esc_html__('No', 'ekobytecore'),
                'return_value' => 'yes',
                'default' => 'no',
            ]
        );
        $this->add_responsive_control(
            'ekobyte_image_height',
            [
                'label' => esc_html__( 'Image Height', 'ekobytecore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekobyte-overlap img' => 'height: {{SIZE}}{{UNIT}};',
                ],
            ]
        );
        $this->add_responsive_control(
            'ekobyte_image_overlap_x',
            [
                'label' => esc_html__( 'Image overlap position', 'ekobytecore' ),
                'type' => Controls_Manager::SLIDER,
                'size_units' => [ 'px', '%' ],
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 1000,
                        'step' => 1,
                    ],
                    '%' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .ekobyte-overlap img' => 'margin-top: {{SIZE}}{{UNIT}};',
                ],
                'condition' => array(
                    'ekobyte_image_overlap' => 'yes',
                ),
            ]
        );

        
        // Top left counter
        $this->add_control(
            'ekobyte_top_left_counter_text',
            [
                'label' => esc_html__('Top Left Counter Text', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Counter text', 'ekobytecore'),
                'placeholder' => esc_html__('Type counter text', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'ekobyte_top_left_counter_value',
            [
                'label' => esc_html__('Top Left Counter Value', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('10', 'ekobytecore'),
                'placeholder' => esc_html__('Type counter value', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        // Bottom right counter
        $this->add_control(
            'ekobyte_bottom_right_counter_text',
            [
                'label' => esc_html__('Bottom Right Counter Text', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('Counter text', 'ekobytecore'),
                'placeholder' => esc_html__('Type counter text', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'ekobyte_bottom_right_counter_value',
            [
                'label' => esc_html__('Bottom Right Counter Value', 'ekobytecore'),
                'description' => ekobyte_get_allowed_html_desc( 'intermediate' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__('1061', 'ekobytecore'),
                'placeholder' => esc_html__('Type counter value', 'ekobytecore'),
                'label_block' => true,
            ]
        );

        $this->end_controls_section();


        /**
         * Style section
         */
		$this->start_controls_section(
			'section_style',
			[
				'label' => __( 'Style', 'ekobytecore' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'text_transform',
			[
				'label' => __( 'Text Transform', 'ekobytecore' ),
				'type' => Controls_Manager::SELECT,
				'default' => '',
				'options' => [
					'' => __( 'None', 'ekobytecore' ),
					'uppercase' => __( 'UPPERCASE', 'ekobytecore' ),
					'lowercase' => __( 'lowercase', 'ekobytecore' ),
					'capitalize' => __( 'Capitalize', 'ekobytecore' ),
				],
				'selectors' => [
					'{{WRAPPER}} .title' => 'text-transform: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();
	}

	/**
	 * Render the widget ouekobyteut on the frontend.
	 *
	 * Written in PHP and used to generate the final HTML.
	 *
	 * @since 1.0.0
	 *
	 * @access protected
	 */
	protected function render() {
        $settings = $this->get_settings_for_display();

        if ( !empty($settings['ekobyte_faq_image']['url']) ) {
            $ekobyte_faq_image = !empty($settings['ekobyte_faq_image']['id']) ? wp_get_attachment_image_url( $settings['ekobyte_faq_image']['id'], $settings['ekobyte_image_size_size']) : $settings['ekobyte_faq_image']['url'];
            $ekobyte_faq_image_alt = get_post_meta($settings["ekobyte_faq_image"]["id"], "_wp_attachment_image_alt", true);
        }

        if ( !empty($settings['ekobyte_border_shape_image']['url']) ) {
            $ekobyte_border_shape_image = !empty($settings['ekobyte_border_shape_image']['id']) ? wp_get_attachment_image_url( $settings['ekobyte_border_shape_image']['id'], $settings['ekobyte_image_size_size']) : $settings['ekobyte_border_shape_image']['url'];
            $ekobyte_border_shape_image_alt = get_post_meta($settings["ekobyte_border_shape_image"]["id"], "_wp_attachment_image_alt", true);
        }
                
        $this->add_render_attribute('title_args', 'class', 'title');
        ?>

        <!-- FAQ Area Start -->
        <div class="faq-area style-1">
            <div class="container">
                <div class="row">
                    <div class="col-xl-7 order-2 order-xxl-1 order-xl-1">
                        <!-- Accordion Start -->
                        <div class="accordion-wrapper">
                            <div class="te-section-title">
                                <div class="te-section-content">
                                    <div>
                                        <?php if ( !empty($settings['ekobyte_sub_title']) ) : ?>    
                                            <span class="short-title only-divider"><?php echo ekobyte_kses( $settings['ekobyte_sub_title'] ); ?></span>
                                        <?php endif; ?>
                                    </div>
                                    <?php
                                        if ( !empty($settings['ekobyte_title' ]) ) :
                                            printf( '<%1$s %2$s>%3$s</%1$s>',
                                                tag_escape( $settings['ekobyte_title_tag'] ),
                                                $this->get_render_attribute_string( 'title_args' ),
                                                ekobyte_kses( $settings['ekobyte_title' ] )
                                                );
                                        endif;
                                    ?>
                                </div>
                            </div>
                            <div class="te-accordion-box-wrapper" id="faq_list">
                                <?php foreach ($settings['accordions'] as $index => $item) :
                                    $collapsed = ($index == '0' ) ? '' : 'collapsed';
                                    $show = ($index == '0' ) ? "show" : "";
                                    ?>
                                    <!-- Single Accordion Start -->
                                    <div class="te-accordion-list-item">
                                        <div id="headingThree">
                                            <div class="te-accordion-head <?php echo esc_attr($collapsed);?>" role="button" data-bs-toggle="collapse" data-bs-target="#collapse<?php echo esc_attr($index);?>" aria-expanded="false" aria-controls="collapseThree">
                                                <h3 class="te-accordion-title"><?php echo esc_html($item['accordion_title']); ?></h3>
                                            </div>
                                        </div>
                                        <div id="collapse<?php echo esc_attr($index);?>" class="accordion-collapse collapse <?php echo esc_attr($show); ?>" aria-labelledby="headingThree" data-bs-parent="#faq_list">
                                            <div class="te-accordion-body">
                                                <p><?php echo ekobyte_kses($item['accordion_description']); ?> </p>
                                            </div>
                                        </div>
                                    </div>
                                    <!-- Single Accordion End -->
                                <?php endforeach; ?> 
                            </div>
                        </div>
                        <!-- Accordion End -->
                    </div>
                    <div class="col-xl-5 p-xxl-0 p-xl-0 order-1 order-xxl-2 order-xl-2">
                        <div class="te-faq-image">
                            <div class="te-image-wrapper">
                                <div class="te-main-img-inner">
                                    <?php if ($settings['ekobyte_faq_image']['url'] || $settings['ekobyte_faq_image']['id']) : ?>
                                        <img src="<?php echo esc_url($ekobyte_faq_image); ?>" alt="<?php echo esc_attr($ekobyte_faq_image_alt); ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="te-image-shape">
                                    <?php if ($settings['ekobyte_border_shape_image']['url'] || $settings['ekobyte_border_shape_image']['id']) : ?>
                                        <img src="<?php echo esc_url($ekobyte_border_shape_image); ?>" alt="<?php echo esc_attr($ekobyte_border_shape_image_alt); ?>">
                                    <?php endif; ?>
                                </div>
                                <div class="top-content content">
                                    <?php if ( !empty($settings['ekobyte_top_left_counter_value']) ) : ?>
                                        <h2 class="number"><span class="counter"><?php echo ekobyte_kses( $settings['ekobyte_top_left_counter_value'] ); ?></span>K+</h2>
                                    <?php endif; ?>
                                    <?php if ( !empty($settings['ekobyte_top_left_counter_text']) ) : ?>
                                        <h6 class="title"><?php echo ekobyte_kses( $settings['ekobyte_top_left_counter_text'] ); ?></h6>
                                    <?php endif; ?>
                                </div>
                                <div class="bottom-content">
                                    <div class="bottom-content-inner content">
                                        <?php if ( !empty($settings['ekobyte_bottom_right_counter_text']) ) : ?>
                                            <h6 class="title"><?php echo ekobyte_kses( $settings['ekobyte_bottom_right_counter_text'] ); ?></h6>
                                        <?php endif; ?>
                                        <?php if ( !empty($settings['ekobyte_bottom_right_counter_value']) ) : ?>
                                            <h2 class="number"><span class="counter"><?php echo ekobyte_kses( $settings['ekobyte_bottom_right_counter_value'] ); ?></span></h2>
                                        <?php endif; ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- FAQ Area End -->

        <?php 
	}
}

$widgets_manager->register( new Ekobyte_Faq() );